/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.support.internal.tools;

import grails.io.IOUtils;
import grails.util.BuildSettings;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.springframework.core.io.FileSystemResource;

class ClassRelativeClassLoader
extends URLClassLoader {
    public ClassRelativeClassLoader(Class targetClass) {
        super(ClassRelativeClassLoader.createClassLoaderUrls(targetClass), ClassLoader.getSystemClassLoader());
    }

    private static URL[] createClassLoaderUrls(Class targetClass) {
        URL root = IOUtils.findRootResource(targetClass);
        if (BuildSettings.RESOURCES_DIR != null && BuildSettings.RESOURCES_DIR.exists()) {
            try {
                return new URL[]{root, new FileSystemResource(BuildSettings.RESOURCES_DIR.getCanonicalFile()).getURL()};
            }
            catch (IOException e) {
                return new URL[]{root};
            }
        }
        return new URL[]{root};
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if ("".equals(name)) {
            final URL[] urls = this.getURLs();
            final int l = urls.length;
            return new Enumeration<URL>(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.i < l;
                }

                @Override
                public URL nextElement() {
                    return urls[this.i++];
                }
            };
        }
        return this.findResources(name);
    }
}

