/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.ssl.BundleContentNotWatchableException;
import org.springframework.boot.autoconfigure.ssl.BundleContentProperty;
import org.springframework.boot.autoconfigure.ssl.FileWatcher;
import org.springframework.boot.autoconfigure.ssl.JksSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.PemSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.PropertiesSslBundle;
import org.springframework.boot.autoconfigure.ssl.SslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.SslBundleRegistrar;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.core.io.ResourceLoader;

class SslPropertiesBundleRegistrar
implements SslBundleRegistrar {
    private final SslProperties.Bundles properties;
    private final FileWatcher fileWatcher;
    private final ResourceLoader resourceLoader;

    SslPropertiesBundleRegistrar(SslProperties properties, FileWatcher fileWatcher, ResourceLoader resourceLoader) {
        this.properties = properties.getBundle();
        this.fileWatcher = fileWatcher;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void registerBundles(SslBundleRegistry registry) {
        this.registerBundles(registry, this.properties.getPem(), PropertiesSslBundle::get, this::watchedPemPaths);
        this.registerBundles(registry, this.properties.getJks(), PropertiesSslBundle::get, this::watchedJksPaths);
    }

    private <P extends SslBundleProperties> void registerBundles(SslBundleRegistry registry, Map<String, P> properties, BiFunction<P, ResourceLoader, SslBundle> bundleFactory, Function<Bundle<P>, Set<Path>> watchedPaths) {
        properties.forEach((bundleName, bundleProperties) -> {
            Supplier<SslBundle> bundleSupplier = () -> (SslBundle)bundleFactory.apply(bundleProperties, this.resourceLoader);
            try {
                registry.registerBundle((String)bundleName, bundleSupplier.get());
                if (bundleProperties.isReloadOnUpdate()) {
                    Supplier<Set<Path>> pathsSupplier = () -> (Set)watchedPaths.apply(new Bundle<SslBundleProperties>((String)bundleName, (SslBundleProperties)bundleProperties));
                    this.watchForUpdates(registry, (String)bundleName, pathsSupplier, bundleSupplier);
                }
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("Unable to register SSL bundle '%s'".formatted(bundleName), ex);
            }
        });
    }

    private void watchForUpdates(SslBundleRegistry registry, String bundleName, Supplier<Set<Path>> pathsSupplier, Supplier<SslBundle> bundleSupplier) {
        try {
            this.fileWatcher.watch(pathsSupplier.get(), () -> registry.updateBundle(bundleName, (SslBundle)bundleSupplier.get()));
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable to watch for reload on update", ex);
        }
    }

    private Set<Path> watchedJksPaths(Bundle<JksSslBundleProperties> bundle) {
        ArrayList<BundleContentProperty> watched = new ArrayList<BundleContentProperty>();
        watched.add(new BundleContentProperty("keystore.location", bundle.properties().getKeystore().getLocation()));
        watched.add(new BundleContentProperty("truststore.location", bundle.properties().getTruststore().getLocation()));
        return this.watchedPaths(bundle.name(), watched);
    }

    private Set<Path> watchedPemPaths(Bundle<PemSslBundleProperties> bundle) {
        ArrayList<BundleContentProperty> watched = new ArrayList<BundleContentProperty>();
        watched.add(new BundleContentProperty("keystore.private-key", bundle.properties().getKeystore().getPrivateKey()));
        watched.add(new BundleContentProperty("keystore.certificate", bundle.properties().getKeystore().getCertificate()));
        watched.add(new BundleContentProperty("truststore.private-key", bundle.properties().getTruststore().getPrivateKey()));
        watched.add(new BundleContentProperty("truststore.certificate", bundle.properties().getTruststore().getCertificate()));
        return this.watchedPaths(bundle.name(), watched);
    }

    private Set<Path> watchedPaths(String bundleName, List<BundleContentProperty> properties) {
        try {
            return properties.stream().filter(BundleContentProperty::hasValue).map(content -> content.toWatchPath(this.resourceLoader)).collect(Collectors.toSet());
        }
        catch (BundleContentNotWatchableException ex) {
            throw ex.withBundleName(bundleName);
        }
    }

    private record Bundle<P>(String name, P properties) {
    }
}

