/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerBuilder;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerCustomizer;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.boot.task.ThreadPoolTaskSchedulerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

class TaskSchedulingConfigurations {
    TaskSchedulingConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class SimpleAsyncTaskSchedulerBuilderConfiguration {
        private final TaskSchedulingProperties properties;
        private final ObjectProvider<TaskDecorator> taskDecorator;
        private final ObjectProvider<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers;

        SimpleAsyncTaskSchedulerBuilderConfiguration(TaskSchedulingProperties properties, ObjectProvider<TaskDecorator> taskDecorator, ObjectProvider<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers) {
            this.properties = properties;
            this.taskDecorator = taskDecorator;
            this.taskSchedulerCustomizers = taskSchedulerCustomizers;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        SimpleAsyncTaskSchedulerBuilder simpleAsyncTaskSchedulerBuilder() {
            return this.builder();
        }

        @Bean(name={"simpleAsyncTaskSchedulerBuilder"})
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskSchedulerBuilder simpleAsyncTaskSchedulerBuilderVirtualThreads() {
            return this.builder().virtualThreads(true);
        }

        private SimpleAsyncTaskSchedulerBuilder builder() {
            SimpleAsyncTaskSchedulerBuilder builder = new SimpleAsyncTaskSchedulerBuilder();
            builder = builder.threadNamePrefix(this.properties.getThreadNamePrefix());
            builder = builder.taskDecorator(this.taskDecorator.getIfUnique());
            builder = builder.customizers(this.taskSchedulerCustomizers.orderedStream()::iterator);
            TaskSchedulingProperties.Simple simple = this.properties.getSimple();
            builder = builder.concurrencyLimit(simple.getConcurrencyLimit());
            TaskSchedulingProperties.Shutdown shutdown = this.properties.getShutdown();
            if (shutdown.isAwaitTermination()) {
                builder = builder.taskTerminationTimeout(shutdown.getAwaitTerminationPeriod());
            }
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ThreadPoolTaskSchedulerBuilderConfiguration {
        ThreadPoolTaskSchedulerBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ThreadPoolTaskSchedulerBuilder threadPoolTaskSchedulerBuilder(TaskSchedulingProperties properties, ObjectProvider<TaskDecorator> taskDecorator, ObjectProvider<ThreadPoolTaskSchedulerCustomizer> threadPoolTaskSchedulerCustomizers) {
            TaskSchedulingProperties.Shutdown shutdown = properties.getShutdown();
            ThreadPoolTaskSchedulerBuilder builder = new ThreadPoolTaskSchedulerBuilder();
            builder = builder.poolSize(properties.getPool().getSize());
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.taskDecorator(taskDecorator.getIfUnique());
            builder = builder.customizers(threadPoolTaskSchedulerCustomizers);
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(name={"org.springframework.context.annotation.internalScheduledAnnotationProcessor"})
    @ConditionalOnMissingBean(value={TaskScheduler.class, ScheduledExecutorService.class})
    static class TaskSchedulerConfiguration {
        TaskSchedulerConfiguration() {
        }

        @Bean(name={"taskScheduler"})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskScheduler taskSchedulerVirtualThreads(SimpleAsyncTaskSchedulerBuilder builder) {
            return builder.build();
        }

        @Bean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskScheduler taskScheduler(ThreadPoolTaskSchedulerBuilder threadPoolTaskSchedulerBuilder) {
            return threadPoolTaskSchedulerBuilder.build();
        }
    }
}

