/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.embedded.JettyThreadPool;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.unit.DataSize;

public class JettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    static final int ORDER = 0;
    private final Environment environment;
    private final ServerProperties serverProperties;

    public JettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableJettyWebServerFactory factory) {
        ServerProperties.Jetty properties = this.serverProperties.getJetty();
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        ServerProperties.Jetty.Threads threadProperties = properties.getThreads();
        factory.setThreadPool((ThreadPool)JettyThreadPool.create(properties.getThreads()));
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getMaxConnections).to(factory::setMaxConnections);
        map.from(threadProperties::getAcceptors).to(factory::setAcceptors);
        map.from(threadProperties::getSelectors).to(factory::setSelectors);
        map.from(this.serverProperties::getMaxHttpRequestHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeHttpConfigurations(factory, HttpConfiguration::setRequestHeaderSize));
        map.from(properties::getMaxHttpResponseHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeHttpConfigurations(factory, HttpConfiguration::setResponseHeaderSize));
        map.from(properties::getMaxHttpFormPostSize).asInt(DataSize::toBytes).when(this::isPositive).to(this.customizeServletContextHandler(factory, ServletContextHandler::setMaxFormContentSize));
        map.from(properties::getMaxFormKeys).when(this::isPositive).to(this.customizeServletContextHandler(factory, ServletContextHandler::setMaxFormKeys));
        map.from(properties::getConnectionIdleTimeout).as(Duration::toMillis).to(this.customizeAbstractConnectors(factory, AbstractConnector::setIdleTimeout));
        map.from(properties::getAccesslog).when(ServerProperties.Jetty.Accesslog::isEnabled).to(accesslog -> this.customizeAccessLog(factory, (ServerProperties.Jetty.Accesslog)accesslog));
    }

    private boolean isPositive(Integer value) {
        return value > 0;
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private <T> Consumer<T> customizeHttpConfigurations(ConfigurableJettyWebServerFactory factory, BiConsumer<HttpConfiguration, T> action) {
        return this.customizeConnectionFactories(factory, HttpConfiguration.ConnectionFactory.class, (connectionFactory, value) -> action.accept(connectionFactory.getHttpConfiguration(), value));
    }

    private <V, F> Consumer<V> customizeConnectionFactories(ConfigurableJettyWebServerFactory factory, Class<F> connectionFactoryType, BiConsumer<F, V> action) {
        return this.customizeConnectors(factory, Connector.class, (connector, value) -> {
            Stream connectionFactories = connector.getConnectionFactories().stream();
            this.forEach(connectionFactories, connectionFactoryType, action, value);
        });
    }

    private <V> Consumer<V> customizeAbstractConnectors(ConfigurableJettyWebServerFactory factory, BiConsumer<AbstractConnector, V> action) {
        return this.customizeConnectors(factory, AbstractConnector.class, action);
    }

    private <V, C> Consumer<V> customizeConnectors(ConfigurableJettyWebServerFactory factory, Class<C> connectorType, BiConsumer<C, V> action) {
        return value -> factory.addServerCustomizers(server -> {
            Stream<Connector> connectors = Arrays.stream(server.getConnectors());
            this.forEach(connectors, connectorType, action, value);
        });
    }

    private <V> Consumer<V> customizeServletContextHandler(ConfigurableJettyWebServerFactory factory, BiConsumer<ServletContextHandler, V> action) {
        return this.customizeHandlers(factory, ServletContextHandler.class, action);
    }

    private <V, H> Consumer<V> customizeHandlers(ConfigurableJettyWebServerFactory factory, Class<H> handlerType, BiConsumer<H, V> action) {
        return value -> factory.addServerCustomizers(server -> {
            List handlers = server.getHandlers();
            this.forEachHandler(handlers, handlerType, action, value);
        });
    }

    private <V, H> void forEachHandler(List<Handler> handlers, Class<H> handlerType, BiConsumer<H, V> action, V value) {
        for (Handler handler : handlers) {
            if (handlerType.isInstance(handler)) {
                action.accept(handler, value);
            }
            if (handler instanceof Handler.Wrapper) {
                Handler.Wrapper wrapper = (Handler.Wrapper)handler;
                this.forEachHandler(wrapper.getHandlers(), handlerType, action, value);
            }
            if (!(handler instanceof Handler.Collection)) continue;
            Handler.Collection collection = (Handler.Collection)handler;
            this.forEachHandler(collection.getHandlers(), handlerType, action, value);
        }
    }

    private <T, V> void forEach(Stream<?> elements, Class<T> type, BiConsumer<T, V> action, V value) {
        elements.filter(type::isInstance).map(type::cast).forEach(element -> action.accept(element, value));
    }

    private void customizeAccessLog(ConfigurableJettyWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
        factory.addServerCustomizers(server -> {
            RequestLogWriter logWriter = new RequestLogWriter();
            String format = this.getLogFormat(properties);
            CustomRequestLog log = new CustomRequestLog((RequestLog.Writer)logWriter, format);
            if (!CollectionUtils.isEmpty(properties.getIgnorePaths())) {
                log.setIgnorePaths(properties.getIgnorePaths().toArray(new String[0]));
            }
            if (properties.getFilename() != null) {
                logWriter.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                logWriter.setFilenameDateFormat(properties.getFileDateFormat());
            }
            logWriter.setRetainDays(properties.getRetentionPeriod());
            logWriter.setAppend(properties.isAppend());
            server.setRequestLog((RequestLog)log);
        });
    }

    private String getLogFormat(ServerProperties.Jetty.Accesslog properties) {
        if (properties.getCustomFormat() != null) {
            return properties.getCustomFormat();
        }
        if (ServerProperties.Jetty.Accesslog.Format.EXTENDED_NCSA.equals((Object)properties.getFormat())) {
            return "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        return "%{client}a - %u %t \"%r\" %s %O";
    }
}

