/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.time.Duration;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactorHttpExchangeAdapter
implements ReactorHttpExchangeAdapter,
HttpClientAdapter {
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    @Nullable
    private Duration blockTimeout;

    protected AbstractReactorHttpExchangeAdapter() {
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void setBlockTimeout(@Nullable Duration blockTimeout) {
        this.blockTimeout = blockTimeout;
    }

    @Override
    @Nullable
    public Duration getBlockTimeout() {
        return this.blockTimeout;
    }

    @Override
    public void exchange(HttpRequestValues requestValues) {
        if (this.blockTimeout != null) {
            this.exchangeForMono(requestValues).block(this.blockTimeout);
        } else {
            this.exchangeForMono(requestValues).block();
        }
    }

    @Override
    public HttpHeaders exchangeForHeaders(HttpRequestValues requestValues) {
        HttpHeaders headers = this.blockTimeout != null ? this.exchangeForHeadersMono(requestValues).block(this.blockTimeout) : this.exchangeForHeadersMono(requestValues).block();
        Assert.state(headers != null, "Expected HttpHeaders");
        return headers;
    }

    @Override
    public <T> T exchangeForBody(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.blockTimeout != null ? this.exchangeForBodyMono(requestValues, bodyType).block(this.blockTimeout) : this.exchangeForBodyMono(requestValues, bodyType).block();
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues requestValues) {
        ResponseEntity<Void> entity = this.blockTimeout != null ? this.exchangeForBodilessEntityMono(requestValues).block(this.blockTimeout) : this.exchangeForBodilessEntityMono(requestValues).block();
        Assert.state(entity != null, "Expected ResponseEntity");
        return entity;
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        ResponseEntity<T> entity = this.blockTimeout != null ? this.exchangeForEntityMono(requestValues, bodyType).block(this.blockTimeout) : this.exchangeForEntityMono(requestValues, bodyType).block();
        Assert.state(entity != null, "Expected ResponseEntity");
        return entity;
    }

    @Override
    public Mono<Void> requestToVoid(HttpRequestValues requestValues) {
        return this.exchangeForMono(requestValues);
    }

    @Override
    public Mono<HttpHeaders> requestToHeaders(HttpRequestValues requestValues) {
        return this.exchangeForHeadersMono(requestValues);
    }

    @Override
    public <T> Mono<T> requestToBody(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.exchangeForBodyMono(requestValues, bodyType);
    }

    @Override
    public <T> Flux<T> requestToBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.exchangeForBodyFlux(requestValues, bodyType);
    }

    @Override
    public Mono<ResponseEntity<Void>> requestToBodilessEntity(HttpRequestValues requestValues) {
        return this.exchangeForBodilessEntityMono(requestValues);
    }

    @Override
    public <T> Mono<ResponseEntity<T>> requestToEntity(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.exchangeForEntityMono(requestValues, bodyType);
    }

    @Override
    public <T> Mono<ResponseEntity<Flux<T>>> requestToEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.exchangeForEntityFlux(requestValues, bodyType);
    }
}

