/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.validator;

import org.apache.hc.client5.http.validator.ValidatorType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.Tokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class ETag {
    private final String value;
    private final ValidatorType type;

    public ETag(String value, ValidatorType type) {
        this.value = Args.notNull(value, "Value");
        this.type = Args.notNull(type, "Validator type");
    }

    public ETag(String value) {
        this(value, ValidatorType.STRONG);
    }

    public ValidatorType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean strongCompare(ETag t1, ETag t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.type == ValidatorType.STRONG && t1.type == t2.type && t1.value.equals(t2.value);
    }

    public static boolean weakCompare(ETag t1, ETag t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.value.equals(t2.value);
    }

    static ETag parse(CharSequence buf, Tokenizer.Cursor cursor) {
        Tokenizer tokenizer = Tokenizer.INSTANCE;
        tokenizer.skipWhiteSpace(buf, cursor);
        ValidatorType type = ValidatorType.STRONG;
        if (!cursor.atEnd() && buf.charAt(cursor.getPos()) == 'W') {
            cursor.updatePos(cursor.getPos() + 1);
            if (!cursor.atEnd() && buf.charAt(cursor.getPos()) == '/') {
                type = ValidatorType.WEAK;
                cursor.updatePos(cursor.getPos() + 1);
            } else {
                return null;
            }
        }
        String value = null;
        if (!cursor.atEnd() && buf.charAt(cursor.getPos()) == '\"') {
            cursor.updatePos(cursor.getPos() + 1);
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (cursor.atEnd()) {
                    return null;
                }
                char ch = buf.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (ch == '\"') break;
                sb.append(ch);
            }
            value = sb.toString();
        }
        tokenizer.skipWhiteSpace(buf, cursor);
        if (!cursor.atEnd()) {
            return null;
        }
        return new ETag(value, type);
    }

    public static ETag parse(String s) {
        if (s == null) {
            return null;
        }
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, s.length());
        return ETag.parse(s, cursor);
    }

    public static ETag parse(Header h) {
        if (h == null) {
            return null;
        }
        String value = h.getValue();
        if (value == null) {
            return null;
        }
        return ETag.parse(value);
    }

    public static ETag get(MessageHeaders message) {
        if (message == null) {
            return null;
        }
        return ETag.parse(message.getFirstHeader("ETag"));
    }

    @Internal
    public void format(CharArrayBuffer buf) {
        if (buf == null) {
            return;
        }
        if (this.type == ValidatorType.WEAK) {
            buf.append("W/");
        }
        buf.append('\"');
        buf.append(this.value);
        buf.append('\"');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ETag) {
            ETag that = (ETag)o;
            return this.type == that.type && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, (Object)this.type);
        hash = LangUtils.hashCode(hash, this.value);
        return hash;
    }

    public String toString() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        this.format(buf);
        return buf.toString();
    }
}

