/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.web;

import grails.artefact.Artefact;
import grails.artefact.controller.support.AllowedMethodsHelper;
import grails.compiler.DelegatingMethod;
import grails.compiler.ast.AnnotatedClassInjector;
import grails.compiler.ast.AstTransformer;
import grails.compiler.ast.GrailsArtefactClassInjector;
import grails.persistence.Entity;
import grails.util.CollectionUtils;
import grails.util.TypeConvertingMap;
import grails.validation.Validateable;
import grails.web.Action;
import grails.web.RequestParameter;
import grails.web.controllers.ControllerMethod;
import groovy.lang.Closure;
import groovy.transform.CompilationUnitAware;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.TraitInjectionUtils;
import org.grails.plugins.web.controllers.DefaultControllerExceptionHandlerMetaData;
import org.grails.web.databinding.DefaultASTDatabindingHelper;
import org.springframework.validation.Errors;
import org.springframework.validation.MapBindingResult;

@AstTransformer
public class ControllerActionTransformer
implements GrailsArtefactClassInjector,
AnnotatedClassInjector,
CompilationUnitAware {
    public static final AnnotationNode DELEGATING_METHOD_ANNOATION = new AnnotationNode(ClassHelper.make(DelegatingMethod.class));
    public static Pattern CONTROLLER_PATTERN = Pattern.compile(".+/grails-app/controllers/(.+)Controller\\.groovy");
    private static final String ALLOWED_METHODS_HANDLED_ATTRIBUTE_NAME = "ALLOWED_METHODS_HANDLED";
    private static final ClassNode OBJECT_CLASS = new ClassNode(Object.class);
    public static final AnnotationNode ACTION_ANNOTATION_NODE = new AnnotationNode(new ClassNode(Action.class));
    private static final String ACTION_MEMBER_TARGET = "commandObjects";
    public static final String EXCEPTION_HANDLER_META_DATA_FIELD_NAME = "$exceptionHandlerMetaData";
    private static final TupleExpression EMPTY_TUPLE = new TupleExpression();
    private static final Map<ClassNode, String> TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME = CollectionUtils.newMap(ClassHelper.Integer_TYPE, "int", ClassHelper.Float_TYPE, "float", ClassHelper.Long_TYPE, "long", ClassHelper.Double_TYPE, "double", ClassHelper.Short_TYPE, "short", ClassHelper.Boolean_TYPE, "boolean", ClassHelper.Byte_TYPE, "byte", ClassHelper.Character_TYPE, "char");
    private static List<ClassNode> PRIMITIVE_CLASS_NODES = CollectionUtils.newList(ClassHelper.boolean_TYPE, ClassHelper.char_TYPE, ClassHelper.int_TYPE, ClassHelper.short_TYPE, ClassHelper.long_TYPE, ClassHelper.double_TYPE, ClassHelper.float_TYPE, ClassHelper.byte_TYPE);
    public static final String VOID_TYPE = "void";
    public static final String CONVERT_CLOSURES_KEY = "grails.compile.artefacts.closures.convert";
    private Boolean converterEnabled = Boolean.parseBoolean(System.getProperty("grails.compile.artefacts.closures.convert"));
    private CompilationUnit compilationUnit;

    @Override
    public String[] getArtefactTypes() {
        return new String[]{"Controller"};
    }

    @Override
    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (!classNode.getAnnotations(new ClassNode(Artefact.class)).isEmpty()) {
            return;
        }
        this.performInjectionOnAnnotatedClass(source, context, classNode);
    }

    @Override
    public void performInjectionOnAnnotatedClass(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        String className = classNode.getName();
        if (className.endsWith("Controller")) {
            this.processMethods(classNode, source, context);
            this.processClosures(classNode, source, context);
        }
    }

    @Override
    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, null, classNode);
    }

    private boolean isExceptionHandlingMethod(MethodNode methodNode) {
        Parameter[] parameters;
        boolean isExceptionHandler = false;
        if (!methodNode.isPrivate() && methodNode.getName().indexOf("$") == -1 && (parameters = methodNode.getParameters()).length == 1) {
            ClassNode parameterTypeClassNode = parameters[0].getType();
            isExceptionHandler = parameterTypeClassNode.isDerivedFrom(new ClassNode(Exception.class));
        }
        return isExceptionHandler;
    }

    private void processMethods(ClassNode classNode, SourceUnit source, GeneratorContext context) {
        ArrayList<MethodNode> deferredNewMethods = new ArrayList<MethodNode>();
        for (MethodNode method : classNode.getMethods()) {
            MethodNode methodNode;
            int n;
            if (!this.methodShouldBeConfiguredAsControllerAction(method)) continue;
            List<MethodNode> declaredMethodsWithThisName = classNode.getDeclaredMethods(method.getName());
            if (declaredMethodsWithThisName != null && (n = DefaultGroovyMethods.count(declaredMethodsWithThisName, new Closure((Object)this){

                public Object call(Object object) {
                    return !ControllerActionTransformer.this.isExceptionHandlingMethod((MethodNode)object);
                }
            }).intValue()) > 1) {
                String message = "Controller actions may not be overloaded.  The [" + method.getName() + "] action has been overloaded in [" + classNode.getName() + "].";
                GrailsASTUtils.error(source, method, message);
            }
            if ((methodNode = this.convertToMethodAction(classNode, method, source, context)) == null) continue;
            deferredNewMethods.add(methodNode);
        }
        Collection<MethodNode> exceptionHandlerMethods = this.getExceptionHandlerMethods(classNode, source);
        FieldNode exceptionHandlerMetaDataField = classNode.getField(EXCEPTION_HANDLER_META_DATA_FIELD_NAME);
        if (exceptionHandlerMetaDataField == null || !exceptionHandlerMetaDataField.getDeclaringClass().equals(classNode)) {
            ListExpression listOfExceptionHandlerMetaData = new ListExpression();
            for (MethodNode exceptionHandlerMethod : exceptionHandlerMethods) {
                Parameter[] parameters = exceptionHandlerMethod.getParameters();
                Parameter firstParameter = parameters[0];
                ClassNode firstParameterTypeClassNode = firstParameter.getType();
                String exceptionHandlerMethodName = exceptionHandlerMethod.getName();
                ArgumentListExpression defaultControllerExceptionHandlerMetaDataCtorArgs = new ArgumentListExpression();
                defaultControllerExceptionHandlerMetaDataCtorArgs.addExpression(new ConstantExpression(exceptionHandlerMethodName));
                defaultControllerExceptionHandlerMetaDataCtorArgs.addExpression(new ClassExpression(firstParameterTypeClassNode.getPlainNodeReference()));
                listOfExceptionHandlerMetaData.addExpression(new ConstructorCallExpression(new ClassNode(DefaultControllerExceptionHandlerMetaData.class), defaultControllerExceptionHandlerMetaDataCtorArgs));
            }
            classNode.addField(EXCEPTION_HANDLER_META_DATA_FIELD_NAME, 26, new ClassNode(List.class), listOfExceptionHandlerMetaData);
        }
        for (MethodNode methodNode : deferredNewMethods) {
            ClassNodeUtils.addGeneratedMethod(classNode, methodNode);
        }
    }

    protected boolean methodShouldBeConfiguredAsControllerAction(MethodNode method) {
        int minLineNumber = 0;
        if (GrailsASTUtils.isInheritedFromTrait(method) && GrailsASTUtils.hasAnnotation(method, Action.class) && GrailsASTUtils.hasParameters(method)) {
            GrailsASTUtils.removeAnnotation(method, Action.class);
            --minLineNumber;
        }
        return !method.isStatic() && method.isPublic() && !method.isAbstract() && method.getAnnotations(ACTION_ANNOTATION_NODE.getClassNode()).isEmpty() && method.getAnnotations(new ClassNode(ControllerMethod.class)).isEmpty() && method.getLineNumber() >= minLineNumber && !method.getName().startsWith("$") && !method.getReturnType().getName().equals(VOID_TYPE) && !this.isExceptionHandlingMethod(method);
    }

    protected Collection<MethodNode> getExceptionHandlerMethods(ClassNode classNode, SourceUnit sourceUnit) {
        HashMap<ClassNode, MethodNode> exceptionTypeToHandlerMethodMap = new HashMap<ClassNode, MethodNode>();
        List<MethodNode> methods = classNode.getMethods();
        for (MethodNode methodNode : methods) {
            if (!this.isExceptionHandlingMethod(methodNode)) continue;
            Parameter exceptionParameter = methodNode.getParameters()[0];
            ClassNode exceptionType = exceptionParameter.getType();
            if (!exceptionTypeToHandlerMethodMap.containsKey(exceptionType)) {
                exceptionTypeToHandlerMethodMap.put(exceptionType, methodNode);
                continue;
            }
            MethodNode otherHandlerMethod = (MethodNode)exceptionTypeToHandlerMethodMap.get(exceptionType);
            String message = "A controller may not define more than 1 exception handler for a particular exception type.  [%s] defines the [%s] and [%s] exception handlers which each accept a [%s] which is not allowed.";
            String formattedMessage = String.format("A controller may not define more than 1 exception handler for a particular exception type.  [%s] defines the [%s] and [%s] exception handlers which each accept a [%s] which is not allowed.", classNode.getName(), otherHandlerMethod.getName(), methodNode.getName(), exceptionType.getName());
            GrailsASTUtils.error(sourceUnit, methodNode, formattedMessage);
        }
        ClassNode superClass = classNode.getSuperClass();
        if (!superClass.equals(OBJECT_CLASS)) {
            Collection<MethodNode> superClassMethods = this.getExceptionHandlerMethods(superClass, sourceUnit);
            for (MethodNode superClassMethod : superClassMethods) {
                Parameter exceptionParameter = superClassMethod.getParameters()[0];
                ClassNode exceptionType = exceptionParameter.getType();
                if (exceptionTypeToHandlerMethodMap.containsKey(exceptionType)) continue;
                exceptionTypeToHandlerMethodMap.put(exceptionType, superClassMethod);
            }
        }
        return exceptionTypeToHandlerMethodMap.values();
    }

    private MethodNode convertToMethodAction(ClassNode classNode, MethodNode methodNode, SourceUnit source, GeneratorContext context) {
        Parameter[] parameters;
        ClassNode returnType = methodNode.getReturnType();
        for (Parameter param : parameters = methodNode.getParameters()) {
            if (!param.hasInitialExpression()) continue;
            String paramName = param.getName();
            String methodName = methodNode.getName();
            String initialValue = param.getInitialExpression().getText();
            String methodDeclaration = methodNode.getText();
            String message = "Parameter [%s] to method [%s] has default value [%s].  Default parameter values are not allowed in controller action methods. ([%s])";
            String formattedMessage = String.format(message, paramName, methodName, initialValue, methodDeclaration);
            GrailsASTUtils.error(source, methodNode, formattedMessage);
        }
        MethodNode method = null;
        if (methodNode.getParameters().length > 0) {
            BlockStatement methodCode = new BlockStatement();
            BlockStatement codeToHandleAllowedMethods = this.getCodeToHandleAllowedMethods(classNode, methodNode.getName());
            Statement codeToCallOriginalMethod = this.addOriginalMethodCall(methodNode, this.initializeActionParameters(classNode, methodNode, methodNode.getName(), parameters, source, context));
            methodCode.addStatement(codeToHandleAllowedMethods);
            methodCode.addStatement(codeToCallOriginalMethod);
            method = new MethodNode(methodNode.getName(), 1, returnType, ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, methodCode);
            GrailsASTUtils.copyAnnotations(methodNode, method);
            methodNode.addAnnotation(DELEGATING_METHOD_ANNOATION);
            this.annotateActionMethod(classNode, parameters, method);
            this.wrapMethodBodyWithExceptionHandling(classNode, method);
        } else {
            this.annotateActionMethod(classNode, parameters, methodNode);
        }
        this.wrapMethodBodyWithExceptionHandling(classNode, methodNode);
        return method;
    }

    private Statement addOriginalMethodCall(MethodNode methodNode, BlockStatement blockStatement) {
        if (blockStatement == null) {
            return null;
        }
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Parameter p : methodNode.getParameters()) {
            arguments.addExpression(new VariableExpression(p.getName(), p.getType()));
        }
        MethodCallExpression callExpression = new MethodCallExpression((Expression)new VariableExpression("this"), methodNode.getName(), (Expression)arguments);
        callExpression.setMethodTarget(methodNode);
        callExpression.setImplicitThis(false);
        blockStatement.addStatement(new ReturnStatement(callExpression));
        return blockStatement;
    }

    private boolean isCommandObjectAction(Parameter[] params) {
        return params != null && params.length > 0 && params[0].getType() != new ClassNode(Object[].class) && params[0].getType() != new ClassNode(Object.class);
    }

    private void processClosures(ClassNode classNode, SourceUnit source, GeneratorContext context) {
        ArrayList<PropertyNode> propertyNodes = new ArrayList<PropertyNode>(classNode.getProperties());
        for (PropertyNode property : propertyNodes) {
            Expression initialExpression = property.getInitialExpression();
            if (property.isStatic() || initialExpression == null || !initialExpression.getClass().equals(ClosureExpression.class)) continue;
            ClosureExpression closureAction = (ClosureExpression)initialExpression;
            if (this.converterEnabled.booleanValue()) {
                this.transformClosureToMethod(classNode, closureAction, property, source, context);
                continue;
            }
            this.addMethodToInvokeClosure(classNode, property, source, context);
        }
    }

    protected void addMethodToInvokeClosure(ClassNode controllerClassNode, PropertyNode closureProperty, SourceUnit source, GeneratorContext context) {
        MethodNode method = controllerClassNode.getMethod(closureProperty.getName(), ZERO_PARAMETERS);
        if (method == null || !method.getDeclaringClass().equals(controllerClassNode)) {
            ClosureExpression closureExpression = (ClosureExpression)closureProperty.getInitialExpression();
            Parameter[] parameters = closureExpression.getParameters();
            BlockStatement newMethodCode = this.initializeActionParameters(controllerClassNode, closureProperty, closureProperty.getName(), parameters, source, context);
            ArgumentListExpression closureInvocationArguments = new ArgumentListExpression();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    closureInvocationArguments.addExpression(new VariableExpression(p.getName()));
                }
            }
            MethodCallExpression methodCallExpression = new MethodCallExpression((Expression)closureExpression, "call", (Expression)closureInvocationArguments);
            newMethodCode.addStatement(new ExpressionStatement(GrailsASTUtils.applyMethodTarget(methodCallExpression, Closure.class, Object.class)));
            MethodNode methodNode = new MethodNode(closureProperty.getName(), 1, new ClassNode(Object.class), ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, newMethodCode);
            this.wrapMethodBodyWithExceptionHandling(controllerClassNode, methodNode);
            this.annotateActionMethod(controllerClassNode, parameters, methodNode);
            ClassNodeUtils.addGeneratedMethod(controllerClassNode, methodNode);
        }
    }

    protected void annotateActionMethod(ClassNode controllerClassNode, Parameter[] parameters, MethodNode methodNode) {
        if (this.isCommandObjectAction(parameters)) {
            ListExpression initArray = new ListExpression();
            for (Parameter parameter : parameters) {
                initArray.addExpression(new ClassExpression(parameter.getType()));
            }
            AnnotationNode paramActionAnn = new AnnotationNode(new ClassNode(Action.class));
            paramActionAnn.setMember(ACTION_MEMBER_TARGET, initArray);
            methodNode.addAnnotation(paramActionAnn);
        } else {
            methodNode.addAnnotation(ACTION_ANNOTATION_NODE);
        }
    }

    protected BlockStatement getCodeToHandleAllowedMethods(ClassNode controllerClass, String methodName) {
        Expression initialAllowedMethodsExpression;
        GrailsASTUtils.addEnhancedAnnotation(controllerClass, "allowedMethods");
        BlockStatement checkAllowedMethodsBlock = new BlockStatement();
        PropertyExpression requestPropertyExpression = new PropertyExpression((Expression)new VariableExpression("this"), "request");
        FieldNode allowedMethodsField = controllerClass.getField("allowedMethods");
        if (allowedMethodsField != null && (initialAllowedMethodsExpression = allowedMethodsField.getInitialExpression()) instanceof MapExpression) {
            boolean actionIsRestricted = false;
            MapExpression allowedMethodsMapExpression = (MapExpression)initialAllowedMethodsExpression;
            List<MapEntryExpression> allowedMethodsMapEntryExpressions = allowedMethodsMapExpression.getMapEntryExpressions();
            for (MapEntryExpression allowedMethodsMapEntryExpression : allowedMethodsMapEntryExpressions) {
                ConstantExpression allowedMethodsMapKeyConstantExpression;
                Object allowedMethodsMapKeyValue;
                Expression allowedMethodsMapEntryKeyExpression = allowedMethodsMapEntryExpression.getKeyExpression();
                if (!(allowedMethodsMapEntryKeyExpression instanceof ConstantExpression) || !methodName.equals(allowedMethodsMapKeyValue = (allowedMethodsMapKeyConstantExpression = (ConstantExpression)allowedMethodsMapEntryKeyExpression).getValue())) continue;
                actionIsRestricted = true;
                break;
            }
            if (actionIsRestricted) {
                PropertyExpression responsePropertyExpression = new PropertyExpression((Expression)new VariableExpression("this"), "response");
                ArgumentListExpression isAllowedArgumentList = new ArgumentListExpression();
                isAllowedArgumentList.addExpression(new ConstantExpression(methodName));
                isAllowedArgumentList.addExpression(new PropertyExpression((Expression)new VariableExpression("this"), "request"));
                isAllowedArgumentList.addExpression(new PropertyExpression((Expression)new VariableExpression("this"), "allowedMethods"));
                StaticMethodCallExpression isAllowedMethodCall = new StaticMethodCallExpression(ClassHelper.make(AllowedMethodsHelper.class), "isAllowed", isAllowedArgumentList);
                BooleanExpression isValidRequestMethod = new BooleanExpression(isAllowedMethodCall);
                MethodCallExpression sendErrorMethodCall = new MethodCallExpression((Expression)responsePropertyExpression, "sendError", (Expression)new ConstantExpression(405));
                ReturnStatement returnStatement = new ReturnStatement(new ConstantExpression(null));
                BlockStatement blockToSendError = new BlockStatement();
                blockToSendError.addStatement(new ExpressionStatement(sendErrorMethodCall));
                blockToSendError.addStatement(returnStatement);
                IfStatement ifIsValidRequestMethodStatement = new IfStatement(isValidRequestMethod, new ExpressionStatement(new EmptyExpression()), blockToSendError);
                checkAllowedMethodsBlock.addStatement(ifIsValidRequestMethodStatement);
            }
        }
        ArgumentListExpression argumentListExpression = new ArgumentListExpression();
        argumentListExpression.addExpression(new ConstantExpression(ALLOWED_METHODS_HANDLED_ATTRIBUTE_NAME));
        argumentListExpression.addExpression(new ConstantExpression(methodName));
        MethodCallExpression setAttributeMethodCall = new MethodCallExpression((Expression)requestPropertyExpression, "setAttribute", (Expression)argumentListExpression);
        BlockStatement codeToExecuteIfAttributeIsNotSet = new BlockStatement();
        codeToExecuteIfAttributeIsNotSet.addStatement(new ExpressionStatement(setAttributeMethodCall));
        codeToExecuteIfAttributeIsNotSet.addStatement(checkAllowedMethodsBlock);
        BooleanExpression attributeIsSetBooleanExpression = new BooleanExpression(new MethodCallExpression((Expression)requestPropertyExpression, "getAttribute", (Expression)new ArgumentListExpression(new ConstantExpression(ALLOWED_METHODS_HANDLED_ATTRIBUTE_NAME))));
        IfStatement ifAttributeIsAlreadySetStatement = new IfStatement(attributeIsSetBooleanExpression, new EmptyStatement(), codeToExecuteIfAttributeIsNotSet);
        BlockStatement code = new BlockStatement();
        code.addStatement(ifAttributeIsAlreadySetStatement);
        return code;
    }

    protected void wrapMethodBodyWithExceptionHandling(ClassNode controllerClassNode, MethodNode methodNode) {
        BlockStatement catchBlockCode = new BlockStatement();
        String caughtExceptionArgumentName = "$caughtException";
        VariableExpression caughtExceptionVariableExpression = new VariableExpression("$caughtException");
        PropertyExpression caughtExceptionTypeExpression = new PropertyExpression((Expression)caughtExceptionVariableExpression, "class");
        VariableExpression thisExpression = new VariableExpression("this");
        MethodCallExpression getExceptionHandlerMethodCall = new MethodCallExpression((Expression)thisExpression, "getExceptionHandlerMethodFor", (Expression)caughtExceptionTypeExpression);
        GrailsASTUtils.applyDefaultMethodTarget(getExceptionHandlerMethodCall, controllerClassNode);
        ClassNode reflectMethodClassNode = new ClassNode(Method.class);
        String exceptionHandlerMethodVariableName = "$method";
        VariableExpression exceptionHandlerMethodExpression = new VariableExpression("$method", new ClassNode(Method.class));
        DeclarationExpression declareExceptionHandlerMethod = new DeclarationExpression(new VariableExpression("$method", reflectMethodClassNode), Token.newSymbol(100, 0, 0), (Expression)getExceptionHandlerMethodCall);
        ArgumentListExpression invokeArguments = new ArgumentListExpression();
        invokeArguments.addExpression(thisExpression);
        invokeArguments.addExpression(caughtExceptionVariableExpression);
        MethodCallExpression invokeExceptionHandlerMethodExpression = new MethodCallExpression((Expression)new VariableExpression("$method"), "invoke", (Expression)invokeArguments);
        GrailsASTUtils.applyDefaultMethodTarget(invokeExceptionHandlerMethodExpression, reflectMethodClassNode);
        ReturnStatement returnStatement = new ReturnStatement(invokeExceptionHandlerMethodExpression);
        ThrowStatement throwCaughtExceptionStatement = new ThrowStatement(caughtExceptionVariableExpression);
        IfStatement ifExceptionHandlerMethodExistsStatement = new IfStatement(new BooleanExpression(exceptionHandlerMethodExpression), returnStatement, throwCaughtExceptionStatement);
        catchBlockCode.addStatement(new ExpressionStatement(declareExceptionHandlerMethod));
        catchBlockCode.addStatement(ifExceptionHandlerMethodExistsStatement);
        CatchStatement catchStatement = new CatchStatement(new Parameter(new ClassNode(Exception.class), "$caughtException"), catchBlockCode);
        Statement methodBody = methodNode.getCode();
        BlockStatement tryBlock = new BlockStatement();
        BlockStatement codeToHandleAllowedMethods = this.getCodeToHandleAllowedMethods(controllerClassNode, methodNode.getName());
        tryBlock.addStatement(codeToHandleAllowedMethods);
        tryBlock.addStatement(methodBody);
        TryCatchStatement tryCatchStatement = new TryCatchStatement(tryBlock, new EmptyStatement());
        tryCatchStatement.addCatch(catchStatement);
        ArgumentListExpression argumentListExpression = new ArgumentListExpression();
        argumentListExpression.addExpression(new ConstantExpression(ALLOWED_METHODS_HANDLED_ATTRIBUTE_NAME));
        PropertyExpression requestPropertyExpression = new PropertyExpression((Expression)new VariableExpression("this"), "request");
        MethodCallExpression removeAttributeMethodCall = new MethodCallExpression((Expression)requestPropertyExpression, "removeAttribute", (Expression)argumentListExpression);
        MethodCallExpression getAttributeMethodCall = new MethodCallExpression((Expression)requestPropertyExpression, "getAttribute", (Expression)new ArgumentListExpression(new ConstantExpression(ALLOWED_METHODS_HANDLED_ATTRIBUTE_NAME)));
        VariableExpression attributeValueExpression = new VariableExpression("$allowed_methods_attribute_value", ClassHelper.make(Object.class));
        DeclarationExpression initializeAttributeValue = new DeclarationExpression(attributeValueExpression, Token.newSymbol(100, 0, 0), (Expression)getAttributeMethodCall);
        BinaryExpression attributeValueMatchesMethodNameExpression = new BinaryExpression(new ConstantExpression(methodNode.getName()), Token.newSymbol(123, 0, 0), attributeValueExpression);
        IfStatement ifAttributeValueMatchesMethodName = new IfStatement(new BooleanExpression(attributeValueMatchesMethodNameExpression), new ExpressionStatement(removeAttributeMethodCall), new EmptyStatement());
        BlockStatement blockToRemoveAttribute = new BlockStatement();
        blockToRemoveAttribute.addStatement(new ExpressionStatement(initializeAttributeValue));
        blockToRemoveAttribute.addStatement(ifAttributeValueMatchesMethodName);
        TryCatchStatement tryCatchToRemoveAttribute = new TryCatchStatement(blockToRemoveAttribute, new EmptyStatement());
        tryCatchToRemoveAttribute.addCatch(new CatchStatement(new Parameter(ClassHelper.make(Exception.class), "$exceptionRemovingAttribute"), new EmptyStatement()));
        tryCatchStatement.setFinallyStatement(tryCatchToRemoveAttribute);
        methodNode.setCode(tryCatchStatement);
    }

    protected void transformClosureToMethod(ClassNode classNode, ClosureExpression closureAction, PropertyNode property, SourceUnit source, GeneratorContext context) {
        MethodNode actionMethod = new MethodNode(property.getName(), 1, property.getType(), closureAction.getParameters(), EMPTY_CLASS_ARRAY, closureAction.getCode());
        MethodNode convertedMethod = this.convertToMethodAction(classNode, actionMethod, source, context);
        if (convertedMethod != null) {
            ClassNodeUtils.addGeneratedMethod(classNode, convertedMethod);
        }
        classNode.getProperties().remove(property);
        classNode.getFields().remove(property.getField());
        ClassNodeUtils.addGeneratedMethod(classNode, actionMethod);
    }

    protected BlockStatement initializeActionParameters(ClassNode classNode, ASTNode actionNode, String actionName, Parameter[] actionParameters, SourceUnit source, GeneratorContext context) {
        BlockStatement wrapper = new BlockStatement();
        ArgumentListExpression mapBindingResultConstructorArgs = new ArgumentListExpression();
        mapBindingResultConstructorArgs.addExpression(new ConstructorCallExpression(new ClassNode(HashMap.class), EMPTY_TUPLE));
        mapBindingResultConstructorArgs.addExpression(new ConstantExpression("controller"));
        ConstructorCallExpression mapBindingResultConstructorCallExpression = new ConstructorCallExpression(new ClassNode(MapBindingResult.class), mapBindingResultConstructorArgs);
        MethodCallExpression errorsAssignmentExpression = GrailsASTUtils.buildSetPropertyExpression(new VariableExpression("this", classNode), "errors", classNode, mapBindingResultConstructorCallExpression);
        wrapper.addStatement(new ExpressionStatement(errorsAssignmentExpression));
        if (actionParameters != null) {
            for (Parameter param : actionParameters) {
                this.initializeMethodParameter(classNode, wrapper, actionNode, actionName, param, source, context);
            }
        }
        return wrapper;
    }

    protected void initializeMethodParameter(ClassNode classNode, BlockStatement wrapper, ASTNode actionNode, String actionName, Parameter param, SourceUnit source, GeneratorContext context) {
        int argNum;
        Parameter[] parameters;
        ClassNode helperClass;
        List<MethodNode> methods;
        Expression traitClass;
        List<AnnotationNode> traitBridges;
        String paramName;
        ClassNode paramTypeClassNode = param.getType();
        String requestParameterName = paramName = param.getName();
        List<AnnotationNode> requestParameters = param.getAnnotations(new ClassNode(RequestParameter.class));
        if (actionNode instanceof MethodNode && paramName.startsWith("arg") && (traitBridges = ((MethodNode)actionNode).getAnnotations(new ClassNode(Traits.TraitBridge.class))).size() == 1 && (traitClass = traitBridges.get(0).getMember("traitClass")) instanceof ClassExpression && (methods = (helperClass = Traits.findHelper(traitClass.getType())).getMethods(actionName)).size() == 1 && (parameters = methods.get(0).getParameters()).length >= (argNum = Integer.valueOf(paramName.replaceFirst("arg", "")).intValue()) + 1) {
            Parameter helperParam = parameters[argNum];
            requestParameterName = helperParam.getName();
            requestParameters = helperParam.getAnnotations(new ClassNode(RequestParameter.class));
        }
        if (requestParameters.size() == 1) {
            requestParameterName = requestParameters.get(0).getMember("value").getText();
        }
        if (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) || TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode)) {
            this.initializePrimitiveOrTypeWrapperParameter(classNode, wrapper, param, requestParameterName);
        } else if (paramTypeClassNode.equals(new ClassNode(String.class))) {
            this.initializeStringParameter(classNode, wrapper, param, requestParameterName);
        } else if (!paramTypeClassNode.equals(OBJECT_CLASS)) {
            this.initializeAndValidateCommandObjectParameter(wrapper, classNode, paramTypeClassNode, actionNode, actionName, paramName, source, context);
        }
    }

    protected void initializeAndValidateCommandObjectParameter(BlockStatement wrapper, ClassNode controllerNode, ClassNode commandObjectNode, ASTNode actionNode, String actionName, String paramName, SourceUnit source, GeneratorContext context) {
        DeclarationExpression declareCoExpression = GeneralUtils.declX(GeneralUtils.localVarX(paramName, commandObjectNode), new EmptyExpression());
        wrapper.addStatement(GeneralUtils.stmt(declareCoExpression));
        if (commandObjectNode.isInterface() || Modifier.isAbstract(commandObjectNode.getModifiers())) {
            String warningMessage = "The [" + actionName + "] action in [" + controllerNode.getName() + "] accepts a parameter of type [" + commandObjectNode.getName() + "].  Interface types and abstract class types are not supported as command objects.  This parameter will be ignored.";
            GrailsASTUtils.warning(source, actionNode, warningMessage);
        } else {
            ModuleNode commandObjectModule;
            boolean argumentIsValidateable;
            this.initializeCommandObjectParameter(wrapper, commandObjectNode, paramName, source);
            boolean bl = argumentIsValidateable = GrailsASTUtils.hasAnyAnnotations(commandObjectNode, Entity.class, jakarta.persistence.Entity.class) || commandObjectNode.implementsInterface(ClassHelper.make(Validateable.class));
            if (!argumentIsValidateable && commandObjectNode.isPrimaryClassNode() && (commandObjectModule = commandObjectNode.getModule()) != null && this.compilationUnit != null) {
                if (commandObjectModule == controllerNode.getModule() || this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "controllers" + File.separator)) {
                    TraitInjectionUtils.injectTrait(this.compilationUnit, source, commandObjectNode, Validateable.class);
                    List<ConstructorNode> declaredConstructors = commandObjectNode.getDeclaredConstructors();
                    List<Statement> objectInitializerStatements = commandObjectNode.getObjectInitializerStatements();
                    if (declaredConstructors.isEmpty() && !objectInitializerStatements.isEmpty()) {
                        BlockStatement constructorLogic = new BlockStatement();
                        ConstructorNode constructorNode = new ConstructorNode(1, constructorLogic);
                        ClassNodeUtils.addGeneratedConstructor(commandObjectNode, constructorNode);
                        constructorLogic.addStatements(objectInitializerStatements);
                    }
                    argumentIsValidateable = true;
                } else if (this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "domain" + File.separator)) {
                    argumentIsValidateable = true;
                }
            }
            if (argumentIsValidateable) {
                MethodCallExpression validateMethodCallExpression = GeneralUtils.callX(GeneralUtils.localVarX(paramName, commandObjectNode), "validate");
                MethodNode validateMethod = commandObjectNode.getMethod("validate", new Parameter[0]);
                if (validateMethod != null) {
                    validateMethodCallExpression.setMethodTarget(validateMethod);
                }
                Statement ifCommandObjectIsNotNullThenValidate = GeneralUtils.ifS((Expression)GeneralUtils.boolX(GeneralUtils.varX(paramName)), GeneralUtils.stmt(validateMethodCallExpression));
                wrapper.addStatement(ifCommandObjectIsNotNullThenValidate);
            } else {
                MethodCallExpression respondsToValidateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "respondsTo", (Expression)new ArgumentListExpression(new ConstantExpression("validate")));
                MethodCallExpression validateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "validate", (Expression)new ArgumentListExpression());
                IfStatement ifRespondsToValidateThenValidateStatement = new IfStatement(new BooleanExpression(respondsToValidateMethodCallExpression), new ExpressionStatement(validateMethodCallExpression), new ExpressionStatement(new EmptyExpression()));
                IfStatement ifCommandObjectIsNotNullThenValidate = new IfStatement(new BooleanExpression(new VariableExpression(paramName)), ifRespondsToValidateThenValidateStatement, new ExpressionStatement(new EmptyExpression()));
                wrapper.addStatement(ifCommandObjectIsNotNullThenValidate);
                String warningMessage = "The [" + actionName + "] action accepts a parameter of type [" + commandObjectNode.getName() + "] which does not implement grails.validation.Validateable.  Data binding will still be applied to this command object but the instance will not be validateable.";
                GrailsASTUtils.warning(source, actionNode, warningMessage);
            }
            if (GrailsASTUtils.isInnerClassNode(commandObjectNode)) {
                String warningMessage = "The [" + actionName + "] action accepts a parameter of type [" + commandObjectNode.getName() + "] which is an inner class. Command object classes should not be inner classes.";
                GrailsASTUtils.warning(source, actionNode, warningMessage);
            } else {
                new DefaultASTDatabindingHelper().injectDatabindingCode(source, context, commandObjectNode);
            }
        }
    }

    protected void initializeCommandObjectParameter(BlockStatement wrapper, ClassNode commandObjectNode, String paramName, SourceUnit source) {
        ArgumentListExpression initializeCommandObjectArguments = GeneralUtils.args(GeneralUtils.classX(commandObjectNode), GeneralUtils.constX(paramName));
        MethodCallExpression initializeCommandObjectMethodCall = GeneralUtils.callThisX("initializeCommandObject", initializeCommandObjectArguments);
        GrailsASTUtils.applyDefaultMethodTarget(initializeCommandObjectMethodCall, commandObjectNode);
        Expression assignCommandObjectToParameter = GeneralUtils.assignX(GeneralUtils.varX(paramName), initializeCommandObjectMethodCall);
        wrapper.addStatement(GeneralUtils.stmt(assignCommandObjectToParameter));
    }

    private boolean doesModulePathIncludeSubstring(ModuleNode moduleNode, String substring) {
        if (moduleNode == null) {
            return false;
        }
        boolean substringFoundInDescription = false;
        String commandObjectModuleDescription = moduleNode.getDescription();
        if (commandObjectModuleDescription != null) {
            substringFoundInDescription = commandObjectModuleDescription.contains(substring);
        }
        return substringFoundInDescription;
    }

    protected void initializeStringParameter(ClassNode classNode, BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        MethodCallExpression getParamsExpression = GrailsASTUtils.buildGetPropertyExpression(GeneralUtils.localVarX("this", classNode), "params", classNode);
        BooleanExpression containsKeyExpression = GeneralUtils.boolX(GrailsASTUtils.applyDefaultMethodTarget(GeneralUtils.callX((Expression)getParamsExpression, "containsKey", (Expression)GeneralUtils.args(GeneralUtils.constX(requestParameterName))), Map.class));
        wrapper.addStatement(GeneralUtils.stmt(GeneralUtils.declX(GeneralUtils.localVarX(methodParamName, paramTypeClassNode), GeneralUtils.ternaryX(containsKeyExpression, GrailsASTUtils.buildGetMapExpression(getParamsExpression, requestParameterName), GeneralUtils.nullX()))));
    }

    protected void initializePrimitiveOrTypeWrapperParameter(ClassNode classNode, BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        ConstantExpression defaultValueExpression = paramTypeClassNode.equals(ClassHelper.Boolean_TYPE) ? new ConstantExpression(false) : (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) ? new ConstantExpression(0) : new ConstantExpression(null));
        ConstantExpression paramConstantExpression = new ConstantExpression(requestParameterName);
        ArgumentListExpression paramsTypeConversionMethodArguments = new ArgumentListExpression(paramConstantExpression, new ConstantExpression(null));
        String conversionMethodName = TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode) ? TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.get(paramTypeClassNode) : paramTypeClassNode.getName();
        MethodCallExpression getParamsExpression = GrailsASTUtils.buildGetPropertyExpression(new VariableExpression("this"), "params", classNode);
        MethodCallExpression retrieveConvertedValueExpression = new MethodCallExpression((Expression)getParamsExpression, conversionMethodName, (Expression)paramsTypeConversionMethodArguments);
        Class<Integer> defaultValueClass = null;
        if ("char".equals(conversionMethodName)) {
            defaultValueClass = Integer.class;
        }
        GrailsASTUtils.applyMethodTarget(retrieveConvertedValueExpression, TypeConvertingMap.class, null, defaultValueClass);
        ArgumentListExpression paramsContainsKeyMethodArguments = new ArgumentListExpression(paramConstantExpression);
        BooleanExpression containsKeyExpression = new BooleanExpression(GrailsASTUtils.applyDefaultMethodTarget(new MethodCallExpression((Expression)getParamsExpression, "containsKey", (Expression)paramsContainsKeyMethodArguments), Map.class));
        Token equalsToken = Token.newSymbol(100, 0, 0);
        VariableExpression convertedValueExpression = new VariableExpression("___converted_" + methodParamName, new ClassNode(Object.class));
        DeclarationExpression declareConvertedValueExpression = new DeclarationExpression(convertedValueExpression, equalsToken, (Expression)new EmptyExpression());
        ExpressionStatement declareVariableStatement = new ExpressionStatement(declareConvertedValueExpression);
        wrapper.addStatement(declareVariableStatement);
        VariableExpression methodParamExpression = GeneralUtils.localVarX(methodParamName, paramTypeClassNode);
        DeclarationExpression declareParameterVariableStatement = new DeclarationExpression(methodParamExpression, equalsToken, (Expression)new EmptyExpression());
        declareVariableStatement = new ExpressionStatement(declareParameterVariableStatement);
        wrapper.addStatement(declareVariableStatement);
        BinaryExpression assignmentExpression = new BinaryExpression(convertedValueExpression, equalsToken, new TernaryExpression(containsKeyExpression, retrieveConvertedValueExpression, defaultValueExpression));
        wrapper.addStatement(new ExpressionStatement(assignmentExpression));
        Expression rejectValueMethodCallExpression = this.getRejectValueExpression(classNode, methodParamName);
        BlockStatement ifConvertedValueIsNullBlockStatement = new BlockStatement();
        ifConvertedValueIsNullBlockStatement.addStatement(new ExpressionStatement(rejectValueMethodCallExpression));
        ifConvertedValueIsNullBlockStatement.addStatement(new ExpressionStatement(new BinaryExpression(methodParamExpression, equalsToken, defaultValueExpression)));
        BooleanExpression isConvertedValueNullExpression = new BooleanExpression(new BinaryExpression(convertedValueExpression, Token.newSymbol(123, 0, 0), new ConstantExpression(null)));
        ExpressionStatement assignConvertedValueToParamStatement = new ExpressionStatement(new BinaryExpression(methodParamExpression, equalsToken, convertedValueExpression));
        IfStatement ifStatement = new IfStatement(isConvertedValueNullExpression, ifConvertedValueIsNullBlockStatement, assignConvertedValueToParamStatement);
        wrapper.addStatement(new IfStatement(new BooleanExpression(containsKeyExpression), ifStatement, new ExpressionStatement(new EmptyExpression())));
    }

    protected Expression getRejectValueExpression(ClassNode classNode, String methodParamName) {
        ArgumentListExpression rejectValueArgs = new ArgumentListExpression();
        rejectValueArgs.addExpression(new ConstantExpression(methodParamName));
        rejectValueArgs.addExpression(new ConstantExpression("params." + methodParamName + ".conversion.error"));
        MethodCallExpression getErrorsExpression = GrailsASTUtils.buildGetPropertyExpression(new VariableExpression("this", classNode), "errors", classNode);
        MethodCallExpression rejectValueMethodCallExpression = GrailsASTUtils.applyDefaultMethodTarget(new MethodCallExpression((Expression)getErrorsExpression, "rejectValue", (Expression)rejectValueArgs), Errors.class);
        return rejectValueMethodCallExpression;
    }

    @Override
    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    @Override
    public boolean shouldInject(URL url) {
        return url != null && CONTROLLER_PATTERN.matcher(url.getFile()).find();
    }

    @Override
    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }
}

