/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import groovy.xml.slurpersupport.GPathResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.io.support.SpringIOUtils;
import org.springframework.core.io.Resource;

public class BinaryGrailsPluginDescriptor {
    private final Resource resource;
    private final List<String> providedlassNames;
    private GPathResult parsedXml;

    public BinaryGrailsPluginDescriptor(Resource resource, List<String> providedlassNames) {
        this.resource = resource;
        this.providedlassNames = providedlassNames;
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<String> getProvidedlassNames() {
        return this.providedlassNames;
    }

    public GPathResult getParsedXml() {
        if (this.parsedXml == null) {
            InputStream inputStream;
            try {
                inputStream = this.resource.getInputStream();
            }
            catch (IOException e) {
                throw new GrailsConfigurationException("Error parsing plugin descript: " + this.resource.getFilename(), e);
            }
            try {
                this.parsedXml = SpringIOUtils.createXmlSlurper().parse(inputStream);
            }
            catch (Throwable e) {
                throw new GrailsConfigurationException("Error parsing plugin descript: " + this.resource.getFilename(), e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return this.parsedXml;
    }
}

