/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.data.cassandra.CassandraManagedTypes;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SessionFactoryFactoryBean;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.ManagedTypes;

@AutoConfiguration(after={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={CqlSession.class, CassandraAdminOperations.class})
@ConditionalOnBean(value={CqlSession.class})
public class CassandraDataAutoConfiguration {
    private final CqlSession session;

    public CassandraDataAutoConfiguration(@Lazy CqlSession session) {
        this.session = session;
    }

    @Bean
    @ConditionalOnMissingBean
    public static CassandraManagedTypes cassandraManagedTypes(BeanFactory beanFactory) throws ClassNotFoundException {
        List<String> packages = EntityScanPackages.get(beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(beanFactory)) {
            packages = AutoConfigurationPackages.get(beanFactory);
        }
        if (!packages.isEmpty()) {
            return CassandraManagedTypes.fromIterable((Iterable)CassandraEntityClassScanner.scan(packages));
        }
        return CassandraManagedTypes.empty();
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraMappingContext cassandraMappingContext(CassandraManagedTypes cassandraManagedTypes, CassandraCustomConversions conversions) {
        CassandraMappingContext context = new CassandraMappingContext();
        context.setManagedTypes((ManagedTypes)cassandraManagedTypes);
        context.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        return context;
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraConverter cassandraConverter(CassandraMappingContext mapping, CassandraCustomConversions conversions) {
        MappingCassandraConverter converter = new MappingCassandraConverter(mapping);
        converter.setCodecRegistry(() -> this.session.getContext().getCodecRegistry());
        converter.setCustomConversions((CustomConversions)conversions);
        converter.setUserTypeResolver((UserTypeResolver)new SimpleUserTypeResolver(this.session));
        return converter;
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionFactory.class})
    public SessionFactoryFactoryBean cassandraSessionFactory(Environment environment2, CassandraConverter converter) {
        SessionFactoryFactoryBean session = new SessionFactoryFactoryBean();
        session.setSession(this.session);
        session.setConverter(converter);
        Binder binder = Binder.get(environment2);
        binder.bind("spring.cassandra.schema-action", SchemaAction.class).ifBound(arg_0 -> ((SessionFactoryFactoryBean)session).setSchemaAction(arg_0));
        return session;
    }

    @Bean
    @ConditionalOnMissingBean(value={CqlOperations.class})
    public CqlTemplate cqlTemplate(SessionFactory sessionFactory) {
        return new CqlTemplate(sessionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={CassandraOperations.class})
    public CassandraTemplate cassandraTemplate(CqlTemplate cqlTemplate, CassandraConverter converter) {
        return new CassandraTemplate((CqlOperations)cqlTemplate, converter);
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraCustomConversions cassandraCustomConversions() {
        return new CassandraCustomConversions(Collections.emptyList());
    }
}

