/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package grails.gorm

import groovy.transform.CompileStatic
import groovy.transform.Generated

import grails.gorm.api.GormAllOperations
import org.grails.datastore.gorm.GormEnhancer
import org.grails.datastore.mapping.core.connections.ConnectionSource

/**
 * A trait for domain classes to implement that should be treated as multi tenant
 *
 * @author Graeme Rocher
 * @since 6.0
 */
@CompileStatic
trait MultiTenant<D> extends Entity {

    /**
     * Execute the closure with the given tenantId
     *
     * @param tenantId The tenant id
     * @param callable The closure
     * @return The result of the closure
     */
    @Generated
    static <T> T withTenant(Serializable tenantId, Closure<T> callable) {
        GormEnhancer.findStaticApi(this).withTenant(tenantId, callable)
    }

    /**
     * Execute the closure for each tenant
     *
     * @param callable The closure
     * @return The result of the closure
     */
    @Generated
    static <D> GormAllOperations eachTenant(Closure callable) {
        GormEnhancer.findStaticApi(this, ConnectionSource.DEFAULT).eachTenant(callable)
    }

    /**
     * Return the {@link GormAllOperations} for the given tenant id
     *
     * @param tenantId The tenant id
     * @return The operations
     */
    @Generated
    static <D> GormAllOperations<D> withTenant(Serializable tenantId) {
        (GormAllOperations<D>) GormEnhancer.findStaticApi(this).withTenant(tenantId)
    }
}
