/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import ognl.ASTAssign;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ASTVarRef
extends SimpleNode
implements NodeType,
OrderedReturn {
    private static final long serialVersionUID = -4497407745162564648L;
    private String name;
    protected Class<?> getterClass;
    protected String core;
    protected String last;

    public ASTVarRef(int id) {
        super(id);
    }

    public ASTVarRef(OgnlParser p, int id) {
        super(p, id);
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        return context.get(this.name);
    }

    @Override
    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        context.put(this.name, value);
    }

    @Override
    public Class<?> getGetterClass() {
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return null;
    }

    @Override
    public String getCoreExpression() {
        return this.core;
    }

    @Override
    public String getLastExpression() {
        return this.last;
    }

    @Override
    public String toString() {
        return "#" + this.name;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        Object value = context.get(this.name);
        if (value != null) {
            this.getterClass = value.getClass();
        }
        context.setCurrentType(this.getterClass);
        context.setCurrentAccessor(context.getClass());
        context.setCurrentObject(value);
        if (context.getCurrentObject() == null) {
            throw new UnsupportedCompilationException("Current context object is null, can't compile var reference.");
        }
        String pre = "";
        String post = "";
        if (context.getCurrentType() != null) {
            pre = "((" + OgnlRuntime.getCompiler().getInterfaceClass(context.getCurrentType()).getName() + ")";
            post = ")";
        }
        if (this.parent instanceof ASTAssign) {
            this.core = "$1.put(\"" + this.name + "\",";
            this.last = pre + "$1.get(\"" + this.name + "\")" + post;
            return this.core;
        }
        return pre + "$1.get(\"" + this.name + "\")" + post;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toGetSourceString(context, target);
    }
}

