/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type.seq;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.Collector;
import com.googlecode.aviator.runtime.type.Sequence;
import com.googlecode.aviator.runtime.type.seq.AbstractSequence;
import java.util.Iterator;

public class LimitedSequence<T>
extends AbstractSequence<T> {
    private final Sequence<T> seq;
    private final int maxLoopCount;

    public LimitedSequence(Sequence<T> seq, int maxLoopCount) {
        this.seq = seq;
        this.maxLoopCount = maxLoopCount;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator rawIt = this.seq.iterator();
        return new Iterator<T>(){
            int c = 0;

            @Override
            public boolean hasNext() {
                return rawIt.hasNext();
            }

            @Override
            public T next() {
                if (++this.c > LimitedSequence.this.maxLoopCount) {
                    throw new ExpressionRuntimeException("Overflow max loop count: " + LimitedSequence.this.maxLoopCount);
                }
                return rawIt.next();
            }

            @Override
            public void remove() {
                rawIt.remove();
            }
        };
    }

    @Override
    public Collector newCollector(int size) {
        return this.seq.newCollector(size);
    }

    @Override
    public int hintSize() {
        return this.seq.hintSize();
    }
}

