/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.trace;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProcedureSpanBuilder
implements Supplier<Span> {
    private final String name;
    private final long procId;
    private final long parentProcId;

    public ProcedureSpanBuilder(Procedure<?> proc) {
        this.name = proc.getProcName();
        this.procId = proc.getProcId();
        this.parentProcId = proc.getParentProcId();
    }

    @Override
    public Span get() {
        return this.build();
    }

    public Span build() {
        return TraceUtil.getGlobalTracer().spanBuilder(this.name).setSpanKind(SpanKind.INTERNAL).setAttribute("procId", this.procId).setAttribute("parentProcId", this.parentProcId).startSpan();
    }
}

