/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.RestUtil;
import org.apache.hadoop.hbase.rest.protobuf.generated.CellMessage;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="Cell")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Private
public class CellModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAGIC_LENGTH = -1;
    @JsonProperty(value="column")
    @XmlAttribute
    private byte[] column;
    @JsonProperty(value="timestamp")
    @XmlAttribute
    private long timestamp = Long.MAX_VALUE;
    private byte[] value;
    @JsonIgnore
    private int valueOffset;
    @JsonIgnore
    private int valueLength = -1;

    public CellModel() {
    }

    public CellModel(byte[] column, byte[] value) {
        this(column, Long.MAX_VALUE, value);
    }

    public CellModel(byte[] column, byte[] qualifier, byte[] value) {
        this(column, qualifier, Long.MAX_VALUE, value);
    }

    public CellModel(Cell cell) {
        this.column = CellModel.makeColumn(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        this.timestamp = cell.getTimestamp();
        this.value = cell.getValueArray();
        this.valueOffset = cell.getValueOffset();
        this.valueLength = cell.getValueLength();
    }

    public CellModel(byte[] column, long timestamp, byte[] value) {
        this.column = column;
        this.timestamp = timestamp;
        this.setValue(value);
    }

    public CellModel(byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        this.column = CellUtil.makeColumn((byte[])family, (byte[])qualifier);
        this.timestamp = timestamp;
        this.setValue(value);
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public boolean hasUserTimestamp() {
        return this.timestamp != Long.MAX_VALUE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="$")
    @XmlValue
    public byte[] getValue() {
        if (this.valueLength == -1) {
            return this.value;
        }
        byte[] retValue = new byte[this.valueLength];
        System.arraycopy(this.value, this.valueOffset, retValue, 0, this.valueLength);
        return retValue;
    }

    public byte[] getValueArray() {
        return this.value;
    }

    @JsonProperty(value="$")
    public void setValue(byte[] value) {
        this.value = value;
        this.valueLength = -1;
    }

    public int getValueOffset() {
        return this.valueOffset;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    @Override
    public Message messageFromObject() {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        builder.setColumn(UnsafeByteOperations.unsafeWrap((byte[])this.getColumn()));
        if (this.valueLength == -1) {
            builder.setData(UnsafeByteOperations.unsafeWrap((byte[])this.getValue()));
        } else {
            builder.setData(UnsafeByteOperations.unsafeWrap((byte[])this.value, (int)this.valueOffset, (int)this.valueLength));
        }
        if (this.hasUserTimestamp()) {
            builder.setTimestamp(this.getTimestamp());
        }
        return builder.build();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(CodedInputStream cis) throws IOException {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        RestUtil.mergeFrom((Message.Builder)builder, cis);
        this.setColumn(builder.getColumn().toByteArray());
        this.setValue(builder.getData().toByteArray());
        if (builder.hasTimestamp()) {
            this.setTimestamp(builder.getTimestamp());
        }
        return this;
    }

    public static byte[] makeColumn(byte[] family, int familyOffset, int familyLength, byte[] qualifier, int qualifierOffset, int qualifierLength) {
        byte[] column = new byte[familyLength + qualifierLength + 1];
        System.arraycopy(family, familyOffset, column, 0, familyLength);
        column[familyLength] = 58;
        System.arraycopy(qualifier, qualifierOffset, column, familyLength + 1, qualifierLength);
        return column;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CellModel cellModel = (CellModel)obj;
        return new EqualsBuilder().append(this.column, cellModel.column).append(this.timestamp, cellModel.timestamp).append(this.getValue(), cellModel.getValue()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.column).append(this.timestamp).append(this.getValue()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("column", this.column).append("timestamp", this.timestamp).append("value", this.getValue()).toString();
    }
}

