/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestDataNodeMXBean {
    public static final Log LOG = LogFactory.getLog(TestDataNodeMXBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBean() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assert.assertEquals((Object)datanode.getClusterId(), (Object)clusterId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((Object)datanode.getVersion(), (Object)version);
            String rpcPort = (String)mbs.getAttribute(mxbeanName, "RpcPort");
            Assert.assertEquals((Object)datanode.getRpcPort(), (Object)rpcPort);
            String httpPort = (String)mbs.getAttribute(mxbeanName, "HttpPort");
            Assert.assertEquals((Object)datanode.getHttpPort(), (Object)httpPort);
            String namenodeAddresses = (String)mbs.getAttribute(mxbeanName, "NamenodeAddresses");
            Assert.assertEquals((Object)datanode.getNamenodeAddresses(), (Object)namenodeAddresses);
            String datanodeHostname = (String)mbs.getAttribute(mxbeanName, "DatanodeHostname");
            Assert.assertEquals((Object)datanode.getDatanodeHostname(), (Object)datanodeHostname);
            String volumeInfo = (String)mbs.getAttribute(mxbeanName, "VolumeInfo");
            Assert.assertEquals((Object)TestDataNodeMXBean.replaceDigits(datanode.getVolumeInfo()), (Object)TestDataNodeMXBean.replaceDigits(volumeInfo));
            int xceiverCount = (Integer)mbs.getAttribute(mxbeanName, "XceiverCount");
            Assert.assertEquals((long)datanode.getXceiverCount(), (long)xceiverCount);
            int xmitsInProgress = (Integer)mbs.getAttribute(mxbeanName, "XmitsInProgress");
            Assert.assertEquals((long)datanode.getXmitsInProgress(), (long)xmitsInProgress);
            String bpActorInfo = (String)mbs.getAttribute(mxbeanName, "BPServiceActorInfo");
            Assert.assertEquals((Object)datanode.getBPServiceActorInfo(), (Object)bpActorInfo);
            String slowDisks = (String)mbs.getAttribute(mxbeanName, "SlowDisks");
            Assert.assertEquals((Object)datanode.getSlowDisks(), (Object)slowDisks);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static String replaceDigits(String s) {
        return s.replaceAll("[0-9]+", "_DIGITS_");
    }

    @Test
    public void testDataNodeMXBeanBlockSize() throws Exception {
        Configuration conf = new Configuration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();){
            DataNode dn = cluster.getDataNodes().get(0);
            for (int i = 0; i < 100; ++i) {
                DFSTestUtil.writeFile((FileSystem)cluster.getFileSystem(), new Path("/foo" + String.valueOf(i) + ".txt"), "test content");
            }
            DataNodeTestUtils.triggerBlockReport(dn);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            String bpActorInfo = (String)mbs.getAttribute(mxbeanName, "BPServiceActorInfo");
            Assert.assertEquals((Object)dn.getBPServiceActorInfo(), (Object)bpActorInfo);
            LOG.info((Object)("bpActorInfo is " + bpActorInfo));
            TypeReference<ArrayList<Map<String, String>>> typeRef = new TypeReference<ArrayList<Map<String, String>>>(){};
            ArrayList bpActorInfoList = (ArrayList)new ObjectMapper().readValue(bpActorInfo, (TypeReference)typeRef);
            int maxDataLength = Integer.valueOf((String)((Map)bpActorInfoList.get(0)).get("maxDataLength"));
            int confMaxDataLength = dn.getConf().getInt("ipc.maximum.data.length", 0x4000000);
            int maxBlockReportSize = Integer.valueOf((String)((Map)bpActorInfoList.get(0)).get("maxBlockReportSize"));
            LOG.info((Object)("maxDataLength is " + maxDataLength));
            LOG.info((Object)("maxBlockReportSize is " + maxBlockReportSize));
            Assert.assertTrue((String)"maxBlockReportSize should be greater than zero", (maxBlockReportSize > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"maxDataLength should be exactly the same value of ipc.maximum.data.length", (long)confMaxDataLength, (long)maxDataLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBeanBlockCount() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            DistributedFileSystem fs = cluster.getFileSystem();
            for (int i = 0; i < 5; ++i) {
                DFSTestUtil.createFile((FileSystem)fs, new Path("/tmp.txt" + i), 1024L, (short)1, 1L);
            }
            Assert.assertEquals((String)"Before restart DN", (long)5L, (long)this.getTotalNumBlocks(mbs, mxbeanName));
            cluster.restartDataNode(0);
            cluster.waitActive();
            Assert.assertEquals((String)"After restart DN", (long)5L, (long)this.getTotalNumBlocks(mbs, mxbeanName));
            fs.delete(new Path("/tmp.txt1"), true);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        return TestDataNodeMXBean.this.getTotalNumBlocks(mbs, mxbeanName) == 4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }, (int)100, (int)30000);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private int getTotalNumBlocks(MBeanServer mbs, ObjectName mxbeanName) throws Exception {
        int totalBlocks = 0;
        String volumeInfo = (String)mbs.getAttribute(mxbeanName, "VolumeInfo");
        Map m = (Map)JSON.parse((String)volumeInfo);
        Collection values = m.values();
        for (Map volumeInfoMap : values) {
            totalBlocks = (int)((long)totalBlocks + (Long)volumeInfoMap.get("numBlocks"));
        }
        return totalBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBeanSlowDisksEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            String slowDiskPath = "test/data1/slowVolume";
            datanode.getDiskMetrics().addSlowDiskForTesting(slowDiskPath, null);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            String slowDisks = (String)mbs.getAttribute(mxbeanName, "SlowDisks");
            Assert.assertEquals((Object)datanode.getSlowDisks(), (Object)slowDisks);
            Assert.assertTrue((boolean)slowDisks.contains(slowDiskPath));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

