/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.minikdc;

import java.io.File;
import java.util.Properties;
import org.apache.hadoop.minikdc.MiniKdc;
import org.junit.After;
import org.junit.Before;

public class KerberosSecurityTestcase {
    private MiniKdc kdc;
    private File workDir;
    private Properties conf;

    @Before
    public void startMiniKdc() throws Exception {
        this.createTestDir();
        this.createMiniKdcConf();
        this.kdc = new MiniKdc(this.conf, this.workDir);
        this.kdc.start();
    }

    public void createTestDir() {
        this.workDir = new File(System.getProperty("test.dir", "target"));
    }

    public void createMiniKdcConf() {
        this.conf = MiniKdc.createConf();
    }

    @After
    public void stopMiniKdc() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
    }

    public MiniKdc getKdc() {
        return this.kdc;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Properties getConf() {
        return this.conf;
    }
}

