/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class TimelineReaderUtils {
    @VisibleForTesting
    public static final char DEFAULT_DELIMITER_CHAR = '!';
    @VisibleForTesting
    public static final char DEFAULT_ESCAPE_CHAR = '*';
    public static final String FROMID_KEY = "FROM_ID";
    @VisibleForTesting
    public static final String UID_KEY = "UID";

    private TimelineReaderUtils() {
    }

    static List<String> split(String str, char delimiterChar, char escapeChar) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int offset = 0;
        int startOffset = 0;
        StringBuilder builder = new StringBuilder(len);
        while (offset < len) {
            if (str.charAt(offset) == escapeChar) {
                if (offset + 1 >= len) {
                    throw new IllegalArgumentException("Escape char not properly escaped.");
                }
                char nextChar = str.charAt(offset + 1);
                if (nextChar != escapeChar && nextChar != delimiterChar) {
                    throw new IllegalArgumentException("Escape char or delimiter char not properly escaped.");
                }
                if (startOffset < offset) {
                    builder.append(str.substring(startOffset, offset));
                }
                builder.append(nextChar);
                startOffset = offset += 2;
                continue;
            }
            if (str.charAt(offset) == delimiterChar) {
                builder.append(str.substring(startOffset, offset));
                list.add(builder.toString().trim());
                startOffset = ++offset;
                builder = new StringBuilder(len - offset);
                continue;
            }
            ++offset;
        }
        if (!str.isEmpty()) {
            builder.append(str.substring(startOffset));
        }
        list.add(builder.toString().trim());
        return list;
    }

    private static String escapeString(String str, char delimiterChar, char escapeChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int startOffset = 0;
        for (int offset = 0; offset < len; ++offset) {
            char charAtOffset = str.charAt(offset);
            if (charAtOffset != escapeChar && charAtOffset != delimiterChar) continue;
            if (startOffset < offset) {
                builder.append(str.substring(startOffset, offset));
            }
            builder.append(escapeChar).append(charAtOffset);
            startOffset = offset + 1;
        }
        builder.append(str.substring(startOffset));
        return builder.toString();
    }

    static String joinAndEscapeStrings(String[] strs, char delimiterChar, char escapeChar) {
        int len = strs.length;
        for (int index = 0; index < len; ++index) {
            if (strs[index] == null) {
                return null;
            }
            strs[index] = TimelineReaderUtils.escapeString(strs[index], delimiterChar, escapeChar);
        }
        return StringUtils.join((Object[])strs, (char)delimiterChar);
    }

    public static List<String> split(String str) throws IllegalArgumentException {
        return TimelineReaderUtils.split(str, '!', '*');
    }

    public static String joinAndEscapeStrings(String[] strs) {
        return TimelineReaderUtils.joinAndEscapeStrings(strs, '!', '*');
    }
}

