/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.hbase.thirdparty.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InfoServer {
    private static final String HBASE_APP_DIR = "hbase-webapps";
    private final HttpServer httpServer;

    public InfoServer(String name, String bindAddress, int port, boolean findPort, Configuration c) throws IOException {
        String httpAuthType;
        HttpConfig httpConfig = new HttpConfig(c);
        HttpServer.Builder builder = new HttpServer.Builder();
        builder.setName(name).addEndpoint(URI.create(httpConfig.getSchemePrefix() + HostAndPort.fromParts(bindAddress, port).toString())).setAppDir(HBASE_APP_DIR).setFindPort(findPort).setConf(c);
        String logDir = System.getProperty("hbase.log.dir");
        if (logDir != null) {
            builder.setLogDir(logDir);
        }
        if (httpConfig.isSecure()) {
            builder.keyPassword(HBaseConfiguration.getPassword(c, "ssl.server.keystore.keypassword", null)).keyStore(c.get("ssl.server.keystore.location"), HBaseConfiguration.getPassword(c, "ssl.server.keystore.password", null), c.get("ssl.server.keystore.type", "jks")).trustStore(c.get("ssl.server.truststore.location"), HBaseConfiguration.getPassword(c, "ssl.server.truststore.password", null), c.get("ssl.server.truststore.type", "jks"));
            builder.excludeCiphers(c.get("ssl.server.exclude.cipher.list"));
        }
        if ("kerberos".equals(httpAuthType = c.get("hbase.security.authentication.ui", "").toLowerCase())) {
            builder.setUsernameConfKey("hbase.security.authentication.spnego.kerberos.principal").setKeytabConfKey("hbase.security.authentication.spnego.kerberos.keytab").setKerberosNameRulesKey("hbase.security.authentication.spnego.kerberos.name.rules").setSignatureSecretFileKey("hbase.security.authentication.signature.secret.file").setSecurityEnabled(true);
        }
        if ("ldap".equals(httpAuthType) || "kerberos".equals(httpAuthType)) {
            AccessControlList acl = InfoServer.buildAdminAcl(c);
            builder.setACL(acl);
        }
        this.httpServer = builder.build();
    }

    static AccessControlList buildAdminAcl(Configuration conf) {
        String httpAuthType = conf.get("hbase.security.authentication.ui", "").toLowerCase();
        String adminUsers = InfoServer.getAdminUsers(conf, httpAuthType);
        String adminGroups = conf.get("hbase.security.authentication.spnego.admin.groups", null);
        if (adminUsers == null && adminGroups == null) {
            return new AccessControlList("*", null);
        }
        return new AccessControlList(adminUsers, adminGroups);
    }

    private static String getAdminUsers(Configuration conf, String httpAuthType) {
        if ("kerberos".equals(httpAuthType)) {
            return conf.get("hbase.security.authentication.spnego.admin.users", null);
        }
        if ("ldap".equals(httpAuthType)) {
            return conf.get("hbase.security.authentication.ldap.admin.users", null);
        }
        return null;
    }

    @Deprecated
    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addUnprivilegedServlet(name, pathSpec, clazz);
    }

    public void addUnprivilegedServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addUnprivilegedServlet(name, pathSpec, clazz);
    }

    public void addUnprivilegedServlet(String name, String pathSpec, ServletHolder holder) {
        if (name != null) {
            holder.setName(name);
        }
        this.httpServer.addUnprivilegedServlet(pathSpec, holder);
    }

    public void addPrivilegedServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addPrivilegedServlet(name, pathSpec, clazz);
    }

    public void setAttribute(String name, Object value) {
        this.httpServer.setAttribute(name, value);
    }

    public void start() throws IOException {
        this.httpServer.start();
    }

    @Deprecated
    public int getPort() {
        return this.httpServer.getPort();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }

    public static boolean canUserModifyUI(HttpServletRequest req, ServletContext ctx, Configuration conf) {
        if (conf.getBoolean("hbase.master.ui.readonly", false)) {
            return false;
        }
        String remoteUser = req.getRemoteUser();
        if ("kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication.ui")) && conf.getBoolean("hadoop.security.authorization", false) && remoteUser != null) {
            return HttpServer.userHasAdministratorAccess(ctx, remoteUser);
        }
        return false;
    }
}

