/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestPageFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPageFilter.class);
    static final int ROW_LIMIT = 3;

    @Test
    public void testPageSize() throws Exception {
        PageFilter f = new PageFilter(3L);
        this.pageSizeTests((Filter)f);
    }

    @Test
    public void testSerialization() throws Exception {
        PageFilter f = new PageFilter(3L);
        byte[] buffer = f.toByteArray();
        PageFilter newFilter = PageFilter.parseFrom((byte[])buffer);
        this.pageSizeTests((Filter)newFilter);
    }

    private void pageSizeTests(Filter f) throws Exception {
        this.testFiltersBeyondPageSize(f, 3);
    }

    private void testFiltersBeyondPageSize(Filter f, int pageSize) throws IOException {
        boolean filterOut;
        int count = 0;
        for (int i = 0; i < pageSize * 2 && !(filterOut = f.filterRow()); ++i) {
            if (++count == pageSize) {
                Assert.assertTrue((boolean)f.filterAllRemaining());
                continue;
            }
            Assert.assertFalse((boolean)f.filterAllRemaining());
        }
        Assert.assertEquals((long)pageSize, (long)count);
    }
}

