/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.osgi;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.ldap.codec.BasicControlDecorator;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeDecorator;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.controls.Cascade;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapCodecService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapCodecService.class);
    private Map<String, ControlFactory<?, ?>> controlFactories = new HashMap();
    private Map<String, ExtendedOperationFactory<?, ?>> extendedOperationsFactories = new HashMap();
    private ProtocolCodecFactory protocolCodecFactory;

    public DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        ControlFactory<Cascade, CascadeDecorator> factory = new CascadeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new EntryChangeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new ManageDsaITFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PagedResultsFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PersistentSearchFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SubentriesFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
    }

    @Override
    public ControlFactory<?, ?> registerControl(ControlFactory<?, ?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?, ?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extendedOperationsFactories.keySet()).iterator();
    }

    @Override
    public ExtendedOperationFactory<?, ?> registerExtendedRequest(ExtendedOperationFactory<?, ?> factory) {
        return this.extendedOperationsFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory oldFactory = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return oldFactory;
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<?, ?> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, control);
        }
        return factory.newCodecControl(control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Object ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }

    @Override
    public ExtendedOperationFactory<?, ?> unregisterExtendedRequest(String oid) {
        return this.extendedOperationsFactories.remove(oid);
    }

    @Override
    public ExtendedResponse toJndi(org.apache.directory.api.ldap.model.message.ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedResponse fromJndi(ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedRequest<?> fromJndi(ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
        return decorator;
    }

    @Override
    public ExtendedRequest toJndi(final org.apache.directory.api.ldap.model.message.ExtendedRequest<?> modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendedOperationsFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator<?, ?> decorator = extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        ExtendedRequest jndiRequest = new ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            @Override
            public String getID() {
                return oid;
            }

            @Override
            public byte[] getEncodedValue() {
                return value;
            }

            @Override
            public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedOperationFactory factory = (ExtendedOperationFactory)DefaultLdapCodecService.this.extendedOperationsFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    ExtendedResponse jndiResponse = new ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        @Override
                        public String getID() {
                            return oid;
                        }

                        @Override
                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                    return jndiResponse;
                }
                catch (DecoderException e) {
                    NamingException ne = new NamingException("Unable to decode encoded response value: " + Strings.dumpBytes(berValue));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        };
        return jndiRequest;
    }

    @Override
    public <E extends org.apache.directory.api.ldap.model.message.ExtendedResponse> E newExtendedResponse(String responseName, int messageId, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator<ExtendedResponseImpl> resp;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendedOperationsFactories.get(responseName);
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator<ExtendedResponseImpl>)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator<ExtendedResponseImpl>((LdapApiService)this, new ExtendedResponseImpl(responseName));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(responseName);
        }
        resp.setMessageId(messageId);
        return (E)resp;
    }

    @Override
    public org.apache.directory.api.ldap.model.message.ExtendedRequest<?> newExtendedRequest(String oid, byte[] value) {
        ExtendedRequestDecorator req = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendedOperationsFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = (ExtendedRequestDecorator)extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator decorator = new ExtendedRequestDecorator((LdapApiService)this, new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    @Override
    public ExtendedRequestDecorator<?, ?> decorate(org.apache.directory.api.ldap.model.message.ExtendedRequest<?> decoratedMessage) {
        ExtendedRequestDecorator<Object, Object> req = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendedOperationsFactories.get(decoratedMessage.getRequestName());
        req = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator((LdapApiService)this, decoratedMessage);
        return req;
    }

    @Override
    public ExtendedResponseDecorator<?> decorate(org.apache.directory.api.ldap.model.message.ExtendedResponse decoratedMessage) {
        ExtendedResponseDecorator<Object> resp = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendedOperationsFactories.get(decoratedMessage.getResponseName());
        resp = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedResponseDecorator<org.apache.directory.api.ldap.model.message.ExtendedResponse>((LdapApiService)this, decoratedMessage);
        return resp;
    }

    @Override
    public boolean isExtendedOperationRegistered(String oid) {
        return this.extendedOperationsFactories.containsKey(oid);
    }
}

