/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.delRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.DeleteRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitDelRequest
extends GrammarAction<LdapMessageContainer<DeleteRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitDelRequest.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitDelRequest() {
        super("Delete Request initialization");
    }

    @Override
    public void action(LdapMessageContainer<DeleteRequestDecorator> container) throws DecoderException {
        DeleteRequestImpl internaldelRequest = new DeleteRequestImpl();
        internaldelRequest.setMessageId(container.getMessageId());
        DeleteRequestDecorator delRequest = new DeleteRequestDecorator(container.getLdapCodecService(), internaldelRequest);
        container.setMessage(delRequest);
        TLV tlv = container.getCurrentTLV();
        Dn entry = null;
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err(I18n.ERR_04073, new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString(dnBytes);
        try {
            entry = new Dn(dnStr);
        }
        catch (LdapInvalidDnException ine) {
            String msg = I18n.err(I18n.ERR_04074, dnStr, Strings.dumpBytes(dnBytes), ine.getLocalizedMessage());
            LOG.error(msg);
            DeleteResponseImpl response = new DeleteResponseImpl(delRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        delRequest.setName(entry);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Deleting Dn {}", (Object)entry);
        }
    }
}

