/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsByteBufferKeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsKeyValue;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, MediumTests.class})
public class TestRowIndexV1RoundTrip {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowIndexV1RoundTrip.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final DataBlockEncoding DATA_BLOCK_ENCODING = DataBlockEncoding.ROW_INDEX_V1;
    private static final int ENTRY_COUNT = 100;
    private Configuration conf;
    private FileSystem fs;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setLong("hbase.server.allocator.minimal.allocate.size", 0L);
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testReadMyWritesOnHeap() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        this.writeDataToHFile(hfilePath, 100);
        this.readDataFromHFile(hfilePath, 100, true);
    }

    @Test
    public void testReadMyWritesOnDirectMem() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        this.writeDataToHFile(hfilePath, 100);
        this.readDataFromHFile(hfilePath, 100, false);
    }

    private void writeDataToHFile(Path hfilePath, int entryCount) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(1024).withDataBlockEncoding(DATA_BLOCK_ENCODING).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR).build();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFile.Writer writer = new HFile.WriterFactory(this.conf, cacheConfig).withPath(this.fs, hfilePath).withFileContext(context).create();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        this.writeKeyValues(entryCount, writer, keyValues);
    }

    private void writeKeyValues(int entryCount, HFile.Writer writer, List<KeyValue> keyValues) throws IOException {
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = this.intToBytes(i);
            byte[] valueBytes = Bytes.toBytes((String)String.format("value %d", i));
            KeyValue keyValue = new KeyValue(keyBytes, null, null, valueBytes);
            writer.append((Cell)keyValue);
            keyValues.add(keyValue);
        }
        writer.close();
    }

    private void readDataFromHFile(Path hfilePath, int entryCount, boolean onHeap) throws IOException {
        CacheConfig cacheConfig;
        if (onHeap) {
            cacheConfig = new CacheConfig(this.conf);
        } else {
            ByteBuffAllocator allocator = ByteBuffAllocator.create((Configuration)this.conf, (boolean)true);
            cacheConfig = new CacheConfig(this.conf, null, null, allocator);
        }
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)hfilePath, (CacheConfig)cacheConfig, (boolean)false, (Configuration)this.conf);
        HFileScanner scanner = reader.getScanner(this.conf, false, false);
        scanner.seekTo();
        int i = 1;
        while (scanner.next()) {
            byte[] keyBytes = this.intToBytes(i);
            Assert.assertArrayEquals((byte[])keyBytes, (byte[])CellUtil.cloneRow((Cell)scanner.getKey()));
            Assert.assertArrayEquals((byte[])keyBytes, (byte[])CellUtil.cloneRow((Cell)scanner.getCell()));
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)String.format("value %d", i)), (byte[])CellUtil.cloneValue((Cell)scanner.getCell()));
            if (onHeap) {
                Assert.assertTrue((boolean)(scanner.getCell() instanceof SizeCachedNoTagsKeyValue));
            } else {
                Assert.assertTrue((boolean)(scanner.getCell() instanceof SizeCachedNoTagsByteBufferKeyValue));
            }
            ++i;
        }
        Assert.assertEquals((long)entryCount, (long)i);
    }

    private byte[] intToBytes(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        return bb.array();
    }
}

