/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionsRecoveryConfigManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionsRecoveryConfigManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionsRecoveryConfigManager.class);
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private MiniHBaseCluster cluster;
    private HMaster hMaster;
    private RegionsRecoveryConfigManager regionsRecoveryConfigManager;
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = HBASE_TESTING_UTILITY.getConfiguration();
        this.conf.unset("hbase.regions.recovery.store.file.ref.count");
        this.conf.unset("hbase.master.regions.recovery.check.interval");
        StartMiniClusterOption option = StartMiniClusterOption.builder().masterClass(TestHMaster.class).numRegionServers(1).numDataNodes(1).build();
        HBASE_TESTING_UTILITY.startMiniCluster(option);
        this.cluster = HBASE_TESTING_UTILITY.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        HBASE_TESTING_UTILITY.shutdownMiniCluster();
    }

    @Test
    public void testChoreSchedule() throws Exception {
        this.hMaster = this.cluster.getMaster();
        this.regionsRecoveryConfigManager = new RegionsRecoveryConfigManager(this.hMaster);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.conf.setInt("hbase.master.regions.recovery.check.interval", 10);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 10);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 20);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 20);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
        this.conf.unset("hbase.regions.recovery.store.file.ref.count");
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryConfigManager.getChore()));
    }

    public static class TestHMaster
    extends HMaster {
        public TestHMaster(Configuration conf) throws IOException {
            super(conf);
        }
    }
}

