/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancerRegionReplicaSameHosts
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerRegionReplicaSameHosts.class);

    @Test
    public void testRegionReplicationOnMidClusterSameHosts() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        loadBalancer.onConfigurationChange(conf);
        int numHosts = 30;
        int numRegions = 900;
        int replication = 3;
        int numRegionsPerServer = 5;
        int numTables = 10;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numHosts, numRegions, numRegionsPerServer, replication, numTables);
        int numNodesPerHost = 4;
        TreeMap<ServerName, List<RegionInfo>> newServerMap = new TreeMap<ServerName, List<RegionInfo>>(serverMap);
        for (Map.Entry<ServerName, List<RegionInfo>> entry : serverMap.entrySet()) {
            for (int i = 1; i < numNodesPerHost; ++i) {
                ServerName s1 = entry.getKey();
                ServerName s2 = ServerName.valueOf((String)s1.getHostname(), (int)(s1.getPort() + i), (long)1L);
                newServerMap.put(s2, new ArrayList());
            }
        }
        this.testWithClusterWithIteration(newServerMap, null, true, true);
    }
}

