/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowRegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowRegionServerTests.class, LargeTests.class})
public class TestLogRolling
extends AbstractTestLogRolling {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogRolling.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestLogRolling.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.setProperty("hbase.tests.use.shortcircuit.reads", "false");
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.client.block.write.retries", 30);
        conf.setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        conf.setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
        conf.set("hbase.wal.provider", "filesystem");
        AbstractTestLogRolling.setUpBeforeClass();
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.wal.slowsync.roll.threshold", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.wal.slowsync.roll.interval.ms", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.wal.roll.on.sync.ms", 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowSyncLogRolling() throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.getName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(desc);
        int row = 1;
        try (Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());){
            this.server = TEST_UTIL.getRSForFirstRegionInTable(desc.getTableName());
            RegionInfo region = ((HRegion)this.server.getRegions(desc.getTableName()).get(0)).getRegionInfo();
            final FSHLog log = (FSHLog)this.server.getWAL(region);
            final AtomicBoolean slowSyncHookCalled = new AtomicBoolean();
            log.registerWALActionsListener(new WALActionsListener(){

                public void logRollRequested(WALActionsListener.RollRequestReason reason) {
                    switch (reason) {
                        case SLOW_SYNC: {
                            slowSyncHookCalled.lazySet(true);
                            break;
                        }
                    }
                }
            });
            for (int i = 0; i < 10; ++i) {
                this.writeData(table, row++);
            }
            Assert.assertFalse((String)"Should not have triggered log roll due to SLOW_SYNC", (boolean)slowSyncHookCalled.get());
            slowSyncHookCalled.set(false);
            final WALProvider.Writer oldWriter1 = log.getWriter();
            final WALProvider.Writer newWriter1 = new WALProvider.Writer(){

                public void close() throws IOException {
                    oldWriter1.close();
                }

                public void sync(boolean forceSync) throws IOException {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException ex = new InterruptedIOException();
                        ex.initCause(e);
                        throw ex;
                    }
                    oldWriter1.sync(forceSync);
                }

                public void append(WAL.Entry entry) throws IOException {
                    oldWriter1.append(entry);
                }

                public long getLength() {
                    return oldWriter1.getLength();
                }

                public long getSyncedLength() {
                    return oldWriter1.getSyncedLength();
                }
            };
            log.setWriter(newWriter1);
            for (int i = 0; i < 10; ++i) {
                this.writeData(table, row++);
            }
            TEST_UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return log.getWriter() != newWriter1;
                }

                public String explainFailure() throws Exception {
                    return "Waited too long for our test writer to get rolled out";
                }
            });
            Assert.assertTrue((String)"Should have triggered log roll due to SLOW_SYNC", (boolean)slowSyncHookCalled.get());
            slowSyncHookCalled.set(false);
            final WALProvider.Writer oldWriter2 = log.getWriter();
            final WALProvider.Writer newWriter2 = new WALProvider.Writer(){

                public void close() throws IOException {
                    oldWriter2.close();
                }

                public void sync(boolean forceSync) throws IOException {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException ex = new InterruptedIOException();
                        ex.initCause(e);
                        throw ex;
                    }
                    oldWriter2.sync(forceSync);
                }

                public void append(WAL.Entry entry) throws IOException {
                    oldWriter2.append(entry);
                }

                public long getLength() {
                    return oldWriter2.getLength();
                }

                public long getSyncedLength() {
                    return oldWriter2.getSyncedLength();
                }
            };
            log.setWriter(newWriter2);
            this.writeData(table, row++);
            TEST_UTIL.waitFor(10000L, 100L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return log.getWriter() != newWriter2;
                }

                public String explainFailure() throws Exception {
                    return "Waited too long for our test writer to get rolled out";
                }
            });
            Assert.assertTrue((String)"Should have triggered log roll due to SLOW_SYNC", (boolean)slowSyncHookCalled.get());
            slowSyncHookCalled.set(false);
            for (int i = 0; i < 10; ++i) {
                this.writeData(table, row++);
            }
            Assert.assertFalse((String)"Should not have triggered log roll due to SLOW_SYNC", (boolean)slowSyncHookCalled.get());
        }
    }

    void batchWriteAndWait(Table table, FSHLog log, int start, boolean expect, int timeout) throws IOException {
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", start + i))));
            put.addColumn(HConstants.CATALOG_FAMILY, null, this.value);
            table.put(put);
        }
        Put tmpPut = new Put(Bytes.toBytes((String)"tmprow"));
        tmpPut.addColumn(HConstants.CATALOG_FAMILY, null, this.value);
        long startTime = EnvironmentEdgeManager.currentTime();
        long remaining = timeout;
        while (remaining > 0L && log.isLowReplicationRollEnabled() != expect) {
            table.put(tmpPut);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remaining = (long)timeout - (EnvironmentEdgeManager.currentTime() - startTime);
        }
    }

    @Test
    public void testLogRollOnDatanodeDeath() throws Exception {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
        Assert.assertTrue((String)"This test requires WAL file replication set to 2.", (this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()) == 2 ? 1 : 0) != 0);
        LOG.info("Replication=" + this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()));
        this.server = this.cluster.getRegionServer(0);
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.getName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        this.admin.createTable(desc);
        Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());
        this.server = TEST_UTIL.getRSForFirstRegionInTable(desc.getTableName());
        RegionInfo region = ((HRegion)this.server.getRegions(desc.getTableName()).get(0)).getRegionInfo();
        FSHLog log = (FSHLog)this.server.getWAL(region);
        final AtomicBoolean lowReplicationHookCalled = new AtomicBoolean(false);
        log.registerWALActionsListener(new WALActionsListener(){

            public void logRollRequested(WALActionsListener.RollRequestReason reason) {
                switch (reason) {
                    case LOW_REPLICATION: {
                        lowReplicationHookCalled.lazySet(true);
                        break;
                    }
                }
            }
        });
        ArrayList existingNodes = this.dfsCluster.getDataNodes();
        int numDataNodes = 3;
        this.dfsCluster.startDataNodes(TEST_UTIL.getConfiguration(), numDataNodes, true, null, null);
        ArrayList allNodes = this.dfsCluster.getDataNodes();
        for (int i = allNodes.size() - 1; i >= 0; --i) {
            if (!existingNodes.contains(allNodes.get(i))) continue;
            this.dfsCluster.stopDataNode(i);
        }
        Assert.assertTrue((String)("DataNodes " + this.dfsCluster.getDataNodes().size() + " default replication " + this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS())), (this.dfsCluster.getDataNodes().size() >= this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()) + 1 ? 1 : 0) != 0);
        this.writeData(table, 2);
        long curTime = EnvironmentEdgeManager.currentTime();
        LOG.info("log.getCurrentFileName(): " + log.getCurrentFileName());
        long oldFilenum = AbstractFSWALProvider.extractFileNumFromWAL((WAL)log);
        Assert.assertTrue((String)"Log should have a timestamp older than now", (curTime > oldFilenum && oldFilenum != -1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"The log shouldn't have rolled yet", (oldFilenum == AbstractFSWALProvider.extractFileNumFromWAL((WAL)log) ? 1 : 0) != 0);
        DatanodeInfo[] pipeline = log.getPipeline();
        Assert.assertTrue((pipeline.length == this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()) ? 1 : 0) != 0);
        Assert.assertTrue((this.dfsCluster.stopDataNode(pipeline[0].getName()) != null ? 1 : 0) != 0);
        this.writeData(table, 2);
        long newFilenum = AbstractFSWALProvider.extractFileNumFromWAL((WAL)log);
        Assert.assertTrue((String)"Missing datanode should've triggered a log roll", (newFilenum > oldFilenum && newFilenum > curTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"The log rolling hook should have been called with the low replication flag", (boolean)lowReplicationHookCalled.get());
        this.writeData(table, 3);
        Assert.assertTrue((String)"The log should not roll again.", (AbstractFSWALProvider.extractFileNumFromWAL((WAL)log) == newFilenum ? 1 : 0) != 0);
        Assert.assertTrue((this.dfsCluster.stopDataNode(pipeline[1].getName()) != null ? 1 : 0) != 0);
        this.batchWriteAndWait(table, log, 3, false, 14000);
        int replication = log.getLogReplication();
        Assert.assertTrue((String)("LowReplication Roller should've been disabled, current replication=" + replication), (!log.isLowReplicationRollEnabled() ? 1 : 0) != 0);
        this.dfsCluster.startDataNodes(TEST_UTIL.getConfiguration(), 1, true, null, null);
        log.rollWriter(true);
        this.batchWriteAndWait(table, log, 13, true, 10000);
        replication = log.getLogReplication();
        Assert.assertTrue((String)("New log file should have the default replication instead of " + replication), (replication == this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"LowReplication Roller should've been enabled", (boolean)log.isLowReplicationRollEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogRollOnPipelineRestart() throws Exception {
        LOG.info("Starting testLogRollOnPipelineRestart");
        Assert.assertTrue((String)"This test requires WAL file replication.", (this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()) > 1 ? 1 : 0) != 0);
        LOG.info("Replication=" + this.fs.getDefaultReplication(TEST_UTIL.getDataTestDirOnTestFS()));
        try (Table t = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            this.server = this.cluster.getRegionServer(0);
            TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.getName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
            this.admin.createTable(desc);
            Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());
            this.server = TEST_UTIL.getRSForFirstRegionInTable(desc.getTableName());
            RegionInfo region = ((HRegion)this.server.getRegions(desc.getTableName()).get(0)).getRegionInfo();
            WAL log = this.server.getWAL(region);
            final ArrayList<Path> paths = new ArrayList<Path>(1);
            final ArrayList preLogRolledCalled = new ArrayList();
            paths.add(AbstractFSWALProvider.getCurrentFileName((WAL)log));
            log.registerWALActionsListener(new WALActionsListener(){

                public void preLogRoll(Path oldFile, Path newFile) {
                    LOG.debug("preLogRoll: oldFile=" + oldFile + " newFile=" + newFile);
                    preLogRolledCalled.add(1);
                }

                public void postLogRoll(Path oldFile, Path newFile) {
                    paths.add(newFile);
                }
            });
            this.writeData(table, 1002);
            long curTime = EnvironmentEdgeManager.currentTime();
            LOG.info("log.getCurrentFileName()): " + AbstractFSWALProvider.getCurrentFileName((WAL)log));
            long oldFilenum = AbstractFSWALProvider.extractFileNumFromWAL((WAL)log);
            Assert.assertTrue((String)"Log should have a timestamp older than now", (curTime > oldFilenum && oldFilenum != -1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"The log shouldn't have rolled yet", (oldFilenum == AbstractFSWALProvider.extractFileNumFromWAL((WAL)log) ? 1 : 0) != 0);
            this.dfsCluster.restartDataNodes();
            Thread.sleep(1000L);
            this.dfsCluster.waitActive();
            LOG.info("Data Nodes restarted");
            this.validateData(table, 1002);
            this.writeData(table, 1003);
            long newFilenum = AbstractFSWALProvider.extractFileNumFromWAL((WAL)log);
            Assert.assertTrue((String)"Missing datanode should've triggered a log roll", (newFilenum > oldFilenum && newFilenum > curTime ? 1 : 0) != 0);
            this.validateData(table, 1003);
            this.writeData(table, 1004);
            this.dfsCluster.restartDataNodes();
            Thread.sleep(1000L);
            this.dfsCluster.waitActive();
            LOG.info("Data Nodes restarted");
            this.validateData(table, 1004);
            this.writeData(table, 1005);
            log.rollWriter(true);
            Assert.assertTrue((String)("preLogRolledCalled has size of " + preLogRolledCalled.size()), (preLogRolledCalled.size() >= 1 ? 1 : 0) != 0);
            HashSet<String> loggedRows = new HashSet<String>();
            for (Path p : paths) {
                LOG.debug("recovering lease for " + p);
                RecoverLeaseFSUtils.recoverFileLease((FileSystem)((HFileSystem)this.fs).getBackingFs(), (Path)p, (Configuration)TEST_UTIL.getConfiguration(), null);
                LOG.debug("Reading WAL " + CommonFSUtils.getPath((Path)p));
                WAL.Reader reader = null;
                try {
                    WAL.Entry entry;
                    reader = WALFactory.createReader((FileSystem)this.fs, (Path)p, (Configuration)TEST_UTIL.getConfiguration());
                    while ((entry = reader.next()) != null) {
                        LOG.debug("#" + entry.getKey().getSequenceId() + ": " + entry.getEdit().getCells());
                        for (Cell cell : entry.getEdit().getCells()) {
                            loggedRows.add(Bytes.toStringBinary((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
                        }
                    }
                }
                catch (EOFException e) {
                    LOG.debug("EOF reading file " + CommonFSUtils.getPath((Path)p));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            Assert.assertTrue((boolean)loggedRows.contains("row1002"));
            Assert.assertTrue((boolean)loggedRows.contains("row1003"));
            Assert.assertTrue((boolean)loggedRows.contains("row1004"));
            Assert.assertTrue((boolean)loggedRows.contains("row1005"));
            for (HRegion r : this.server.getOnlineRegionsLocalContext()) {
                try {
                    r.flush(true);
                }
                catch (Exception e) {
                    LOG.info(e.toString(), (Throwable)e);
                }
            }
            try (ResultScanner scanner = table.getScanner(new Scan());){
                for (int i = 2; i <= 5; ++i) {
                    Result r = scanner.next();
                    Assert.assertNotNull((Object)r);
                    Assert.assertFalse((boolean)r.isEmpty());
                    Assert.assertEquals((Object)("row100" + i), (Object)Bytes.toString((byte[])r.getRow()));
                }
            }
            for (JVMClusterUtil.RegionServerThread rsThread : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
                Assert.assertFalse((boolean)rsThread.getRegionServer().isAborted());
            }
        }
    }
}

