/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCompoundConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompoundConfiguration.class);
    private Configuration baseConf;
    private int baseConfSize;

    @Before
    public void setUp() throws Exception {
        this.baseConf = new Configuration();
        this.baseConf.set("A", "1");
        this.baseConf.setInt("B", 2);
        this.baseConf.set("C", "3");
        this.baseConfSize = this.baseConf.size();
    }

    @Test
    public void testBasicFunctionality() throws ClassNotFoundException {
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf);
        Assert.assertEquals((Object)"1", (Object)compoundConf.get("A"));
        Assert.assertEquals((long)2L, (long)compoundConf.getInt("B", 0));
        Assert.assertEquals((long)3L, (long)compoundConf.getInt("C", 0));
        Assert.assertEquals((long)0L, (long)compoundConf.getInt("D", 0));
        Assert.assertEquals(CompoundConfiguration.class, (Object)compoundConf.getClassByName(CompoundConfiguration.class.getName()));
        try {
            compoundConf.getClassByName("bad_class_name");
            Assert.fail((String)"Trying to load bad_class_name should throw an exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testPut() {
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf);
        Assert.assertEquals((Object)"1", (Object)compoundConf.get("A"));
        Assert.assertEquals((long)2L, (long)compoundConf.getInt("B", 0));
        Assert.assertEquals((long)3L, (long)compoundConf.getInt("C", 0));
        Assert.assertEquals((long)0L, (long)compoundConf.getInt("D", 0));
        compoundConf.set("A", "1337");
        compoundConf.set("string", "stringvalue");
        Assert.assertEquals((long)1337L, (long)compoundConf.getInt("A", 0));
        Assert.assertEquals((Object)"stringvalue", (Object)compoundConf.get("string"));
        Assert.assertEquals((Object)"1", (Object)this.baseConf.get("A"));
        Assert.assertNull((Object)this.baseConf.get("string"));
        this.baseConf.set("setInParent", "fromParent");
        Assert.assertEquals((Object)"fromParent", (Object)compoundConf.get("setInParent"));
    }

    @Test
    public void testWithConfig() {
        Configuration conf = new Configuration();
        conf.set("B", "2b");
        conf.set("C", "33");
        conf.set("D", "4");
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf).add(conf);
        Assert.assertEquals((Object)"1", (Object)compoundConf.get("A"));
        Assert.assertEquals((Object)"2b", (Object)compoundConf.get("B"));
        Assert.assertEquals((long)33L, (long)compoundConf.getInt("C", 0));
        Assert.assertEquals((Object)"4", (Object)compoundConf.get("D"));
        Assert.assertEquals((long)4L, (long)compoundConf.getInt("D", 0));
        Assert.assertNull((Object)compoundConf.get("E"));
        Assert.assertEquals((long)6L, (long)compoundConf.getInt("F", 6));
        int cnt = 0;
        for (Map.Entry entry : compoundConf) {
            ++cnt;
            if (((String)entry.getKey()).equals("B")) {
                Assert.assertEquals((Object)"2b", entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals("G")) continue;
            Assert.assertNull(entry.getValue());
        }
        Assert.assertEquals((long)(this.baseConfSize + 1), (long)cnt);
    }

    private Bytes strToIb(String s) {
        return new Bytes(Bytes.toBytes((String)s));
    }

    @Test
    public void testWithIbwMap() {
        HashMap<Bytes, Bytes> map = new HashMap<Bytes, Bytes>();
        map.put(this.strToIb("B"), this.strToIb("2b"));
        map.put(this.strToIb("C"), this.strToIb("33"));
        map.put(this.strToIb("D"), this.strToIb("4"));
        map.put(this.strToIb("G"), null);
        CompoundConfiguration compoundConf = new CompoundConfiguration().add(this.baseConf).addBytesMap(map);
        Assert.assertEquals((Object)"1", (Object)compoundConf.get("A"));
        Assert.assertEquals((Object)"2b", (Object)compoundConf.get("B"));
        Assert.assertEquals((long)33L, (long)compoundConf.getInt("C", 0));
        Assert.assertEquals((Object)"4", (Object)compoundConf.get("D"));
        Assert.assertEquals((long)4L, (long)compoundConf.getInt("D", 0));
        Assert.assertNull((Object)compoundConf.get("E"));
        Assert.assertEquals((long)6L, (long)compoundConf.getInt("F", 6));
        Assert.assertNull((Object)compoundConf.get("G"));
        int cnt = 0;
        for (Map.Entry entry : compoundConf) {
            ++cnt;
            if (((String)entry.getKey()).equals("B")) {
                Assert.assertEquals((Object)"2b", entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals("G")) continue;
            Assert.assertNull(entry.getValue());
        }
        Assert.assertEquals((long)(this.baseConfSize + 2), (long)cnt);
        CompoundConfiguration conf2 = new CompoundConfiguration();
        conf2.set("X", "modification");
        conf2.set("D", "not4");
        Assert.assertEquals((Object)"modification", (Object)conf2.get("X"));
        Assert.assertEquals((Object)"not4", (Object)conf2.get("D"));
        conf2.addBytesMap(map);
        Assert.assertEquals((Object)"4", (Object)conf2.get("D"));
    }

    @Test
    public void testWithStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("B", "2b");
        map.put("C", "33");
        map.put("D", "4");
        map.put("G", null);
        CompoundConfiguration compoundConf = new CompoundConfiguration().addStringMap(map);
        Assert.assertEquals((Object)"2b", (Object)compoundConf.get("B"));
        Assert.assertEquals((long)33L, (long)compoundConf.getInt("C", 0));
        Assert.assertEquals((Object)"4", (Object)compoundConf.get("D"));
        Assert.assertEquals((long)4L, (long)compoundConf.getInt("D", 0));
        Assert.assertNull((Object)compoundConf.get("E"));
        Assert.assertEquals((long)6L, (long)compoundConf.getInt("F", 6));
        Assert.assertNull((Object)compoundConf.get("G"));
        int cnt = 0;
        for (Map.Entry entry : compoundConf) {
            ++cnt;
            if (((String)entry.getKey()).equals("B")) {
                Assert.assertEquals((Object)"2b", entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals("G")) continue;
            Assert.assertNull(entry.getValue());
        }
        Assert.assertEquals((long)4L, (long)cnt);
        CompoundConfiguration conf2 = new CompoundConfiguration();
        conf2.set("X", "modification");
        conf2.set("D", "not4");
        Assert.assertEquals((Object)"modification", (Object)conf2.get("X"));
        Assert.assertEquals((Object)"not4", (Object)conf2.get("D"));
        conf2.addStringMap(map);
        Assert.assertEquals((Object)"4", (Object)conf2.get("D"));
    }

    @Test
    public void testLaterConfigsOverrideEarlier() {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("A", "2");
        map1.put("D", "5");
        HashMap<String, String> map2 = new HashMap<String, String>();
        String newValueForA = "3";
        String newValueForB = "4";
        map2.put("A", newValueForA);
        map2.put("B", newValueForB);
        CompoundConfiguration compoundConf = new CompoundConfiguration().addStringMap(map1).add(this.baseConf);
        Assert.assertEquals((Object)"1", (Object)compoundConf.get("A"));
        Assert.assertEquals((Object)"5", (Object)compoundConf.get("D"));
        compoundConf.addStringMap(map2);
        Assert.assertEquals((Object)newValueForA, (Object)compoundConf.get("A"));
        Assert.assertEquals((Object)newValueForB, (Object)compoundConf.get("B"));
        Assert.assertEquals((Object)"5", (Object)compoundConf.get("D"));
        int cnt = 0;
        for (Map.Entry entry : compoundConf) {
            ++cnt;
            if (((String)entry.getKey()).equals("A")) {
                Assert.assertEquals((Object)newValueForA, entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals("B")) continue;
            Assert.assertEquals((Object)newValueForB, entry.getValue());
        }
        Assert.assertEquals((long)(this.baseConfSize + 1), (long)cnt);
    }
}

