/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestByteBufferArray {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferArray.class);
    private static final ByteBufferAllocator ALLOC = size -> ByteBuffer.allocateDirect((int)size);

    @Test
    public void testAsSubBufferWhenEndOffsetLandInLastBuffer() throws Exception {
        int capacity = 0x400000;
        ByteBufferArray array = new ByteBufferArray((long)capacity, ALLOC);
        ByteBuff subBuf = ByteBuff.wrap((ByteBuffer[])array.asSubByteBuffers(0L, capacity));
        subBuf.position(capacity - 1);
        Assert.assertTrue((boolean)subBuf.hasRemaining());
        subBuf.get();
        Assert.assertFalse((boolean)subBuf.hasRemaining());
    }

    @Test
    public void testByteBufferCreation() throws Exception {
        int capacity = 490907010;
        ByteBufferArray array = new ByteBufferArray((long)capacity, ALLOC);
        Assert.assertEquals((long)118L, (long)array.buffers.length);
        for (int i = 0; i < array.buffers.length; ++i) {
            Assert.assertEquals((long)0x400000L, (long)array.buffers[i].capacity());
        }
    }

    @Test
    public void testByteBufferCreation1() throws Exception {
        long cap = 0x700000L;
        int bufferSize = ByteBufferArray.getBufferSize((long)cap);
        int bufferCount = 25;
        ByteBufferArray array = new ByteBufferArray(bufferSize, bufferCount, 16, cap, ALLOC);
        for (int i = 0; i < array.buffers.length; ++i) {
            Assert.assertEquals((long)458752L, (long)array.buffers[i].capacity());
        }
    }

    private static void fill(ByteBuff buf, byte val) {
        for (int i = buf.position(); i < buf.limit(); ++i) {
            buf.put(i, val);
        }
    }

    private ByteBuff createByteBuff(int len) {
        assert (len >= 0);
        int pos = len == 0 ? 0 : ThreadLocalRandom.current().nextInt(len);
        ByteBuff b = ByteBuff.wrap((ByteBuffer)ByteBuffer.allocate(2 * len));
        b.position(pos).limit(pos + len);
        return b;
    }

    private void expectedAssert(Call r) throws IOException {
        boolean asserted = true;
        try {
            r.run();
            asserted = false;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        if (!asserted) {
            Assert.fail((String)"Failed to assert expected assertion");
        }
    }

    @Test
    public void testArrayIO() throws IOException {
        int cap = 0x900000;
        int bufferSize = ByteBufferArray.getBufferSize((long)cap);
        ByteBufferArray array = new ByteBufferArray((long)cap, ALLOC);
        this.testReadAndWrite(array, 0, 512, (byte)2);
        this.testReadAndWrite(array, cap - 512, 512, (byte)3);
        this.testReadAndWrite(array, 0x400000, 0x500000, (byte)4);
        this.testReadAndWrite(array, 256, 256, (byte)5);
        this.testReadAndWrite(array, 257, 513, (byte)6);
        this.testReadAndWrite(array, 0, cap, (byte)7);
        this.testReadAndWrite(array, cap, 0, (byte)8);
        this.testReadAndWrite(array, cap - 1, 1, (byte)9);
        this.testReadAndWrite(array, cap - 2, 2, (byte)10);
        this.expectedAssert(() -> this.testReadAndWrite(array, cap - 2, 3, (byte)11));
        this.expectedAssert(() -> this.testReadAndWrite(array, 0, cap + 1, (byte)12));
        this.expectedAssert(() -> this.testReadAndWrite(array, 0, -23, (byte)14));
        this.expectedAssert(() -> this.testReadAndWrite(array, 4096, cap - 4096 + 1, (byte)16));
        this.testAsSubByteBuff(array, 0, cap, true);
        this.testAsSubByteBuff(array, 0, 0, false);
        this.testAsSubByteBuff(array, 0, 1, false);
        this.testAsSubByteBuff(array, 0, bufferSize - 1, false);
        this.testAsSubByteBuff(array, 0, bufferSize, false);
        this.testAsSubByteBuff(array, 0, bufferSize + 1, true);
        this.testAsSubByteBuff(array, 0, 2 * bufferSize, true);
        this.testAsSubByteBuff(array, 0, 5 * bufferSize, true);
        this.testAsSubByteBuff(array, cap - bufferSize - 1, bufferSize, true);
        this.testAsSubByteBuff(array, cap - bufferSize, bufferSize, false);
        this.testAsSubByteBuff(array, cap - bufferSize, 0, false);
        this.testAsSubByteBuff(array, cap - bufferSize, 1, false);
        this.testAsSubByteBuff(array, cap - bufferSize, bufferSize - 1, false);
        this.testAsSubByteBuff(array, cap - 2 * bufferSize, 2 * bufferSize, true);
        this.testAsSubByteBuff(array, cap - 2 * bufferSize, bufferSize + 1, true);
        this.testAsSubByteBuff(array, cap - 2 * bufferSize, bufferSize - 1, false);
        this.testAsSubByteBuff(array, cap - 2 * bufferSize, 0, false);
        this.expectedAssert(() -> this.testAsSubByteBuff(array, 0, cap + 1, false));
        this.expectedAssert(() -> this.testAsSubByteBuff(array, 0, -1, false));
        this.expectedAssert(() -> this.testAsSubByteBuff(array, -1, -1, false));
        this.expectedAssert(() -> this.testAsSubByteBuff(array, cap - bufferSize, bufferSize + 1, false));
        this.expectedAssert(() -> this.testAsSubByteBuff(array, 2 * bufferSize, cap - 2 * bufferSize + 1, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadAndWrite(ByteBufferArray array, int off, int dataSize, byte val) {
        ByteBuff src = this.createByteBuff(dataSize);
        int pos = src.position();
        int lim = src.limit();
        TestByteBufferArray.fill(src, val);
        Assert.assertEquals((long)src.remaining(), (long)dataSize);
        try {
            Assert.assertEquals((long)dataSize, (long)array.write((long)off, src));
            Assert.assertEquals((long)0L, (long)src.remaining());
        }
        finally {
            src.position(pos).limit(lim);
        }
        ByteBuff dst = this.createByteBuff(dataSize);
        pos = dst.position();
        lim = dst.limit();
        try {
            Assert.assertEquals((long)dataSize, (long)array.read((long)off, dst));
            Assert.assertEquals((long)0L, (long)dst.remaining());
        }
        finally {
            dst.position(pos).limit(lim);
        }
        this.assertByteBuffEquals(src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAsSubByteBuff(ByteBufferArray array, int off, int len, boolean isMulti) {
        ByteBuff ret = ByteBuff.wrap((ByteBuffer[])array.asSubByteBuffers((long)off, len));
        if (isMulti) {
            Assert.assertTrue((boolean)(ret instanceof MultiByteBuff));
        } else {
            Assert.assertTrue((boolean)(ret instanceof SingleByteBuff));
        }
        Assert.assertTrue((!ret.hasArray() ? 1 : 0) != 0);
        Assert.assertEquals((long)len, (long)ret.remaining());
        ByteBuff tmp = this.createByteBuff(len);
        int pos = tmp.position();
        int lim = tmp.limit();
        try {
            Assert.assertEquals((long)len, (long)array.read((long)off, tmp));
            Assert.assertEquals((long)0L, (long)tmp.remaining());
        }
        finally {
            tmp.position(pos).limit(lim);
        }
        this.assertByteBuffEquals(ret, tmp);
    }

    private void assertByteBuffEquals(ByteBuff a, ByteBuff b) {
        Assert.assertEquals((long)a.remaining(), (long)b.remaining());
        int i = a.position();
        int j = b.position();
        while (i < a.limit()) {
            Assert.assertEquals((long)a.get(i), (long)b.get(j));
            ++i;
            ++j;
        }
    }

    private static interface Call {
        public void run() throws IOException;
    }
}

