/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.etypeInfo.actions;

import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.etypeInfo.ETypeInfoContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.codec.etypeInfoEntry.ETypeInfoEntryContainer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.ETypeInfoEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddETypeInfoEntry
extends GrammarAction<ETypeInfoContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddETypeInfoEntry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddETypeInfoEntry() {
        super("Add an ETypeInfoEntry instance");
    }

    public void action(ETypeInfoContainer eTypeInfoContainer) throws DecoderException {
        TLV tlv = eTypeInfoContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder etypeInfoEntryDecoder = new Asn1Decoder();
        ETypeInfoEntryContainer etypeInfoEntryContainer = new ETypeInfoEntryContainer();
        etypeInfoEntryContainer.setStream(eTypeInfoContainer.getStream());
        eTypeInfoContainer.rewind();
        etypeInfoEntryDecoder.decode(eTypeInfoContainer.getStream(), (Asn1Container)etypeInfoEntryContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        eTypeInfoContainer.updateParent();
        ETypeInfoEntry etypeInfoEntry = etypeInfoEntryContainer.getETypeInfoEntry();
        eTypeInfoContainer.addEtypeInfoEntry(etypeInfoEntry);
        if (IS_DEBUG) {
            LOG.debug("ETYPE-INFO-ENTRY added : {}", (Object)etypeInfoEntry);
        }
        eTypeInfoContainer.setGrammarEndAllowed(true);
    }
}

