/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Strings {
    public static final String DEFAULT_SEPARATOR = "=";
    public static final String DEFAULT_KEYVALUE_SEPARATOR = ", ";

    private Strings() {
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value) {
        return Strings.appendKeyValue(sb, key, value, DEFAULT_SEPARATOR, DEFAULT_KEYVALUE_SEPARATOR);
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value, String separator, String keyValueSeparator) {
        if (sb.length() > 0) {
            sb.append(keyValueSeparator);
        }
        return sb.append(key).append(separator).append(value);
    }

    public static String domainNamePointerToHostName(String dnPtr) {
        if (dnPtr == null) {
            return null;
        }
        return dnPtr.endsWith(".") ? dnPtr.substring(0, dnPtr.length() - 1) : dnPtr;
    }

    public static String padFront(String input, char padding, int length) {
        if (input.length() > length) {
            throw new IllegalArgumentException("input \"" + input + "\" longer than maxLength=" + length);
        }
        int numPaddingCharacters = length - input.length();
        return StringUtils.repeat(padding, numPaddingCharacters) + input;
    }

    public static String humanReadableInt(long number) {
        return StringUtils.TraditionalBinaryPrefix.long2String(number, "", 1);
    }
}

