/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringInterner;

class TaggedInputSplit
extends InputSplit
implements Configurable,
Writable {
    private Class<? extends InputSplit> inputSplitClass;
    private InputSplit inputSplit;
    private Class<? extends InputFormat> inputFormatClass;
    private Class<? extends Mapper> mapperClass;
    private Configuration conf;

    public TaggedInputSplit() {
    }

    public TaggedInputSplit(InputSplit inputSplit, Configuration conf, Class<? extends InputFormat> inputFormatClass, Class<? extends Mapper> mapperClass) {
        this.inputSplitClass = inputSplit.getClass();
        this.inputSplit = inputSplit;
        this.conf = conf;
        this.inputFormatClass = inputFormatClass;
        this.mapperClass = mapperClass;
    }

    public InputSplit getInputSplit() {
        return this.inputSplit;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public long getLength() throws IOException, InterruptedException {
        return this.inputSplit.getLength();
    }

    @Override
    public String[] getLocations() throws IOException, InterruptedException {
        return this.inputSplit.getLocations();
    }

    public void readFields(DataInput in) throws IOException {
        this.inputSplitClass = this.readClass(in);
        this.inputFormatClass = this.readClass(in);
        this.mapperClass = this.readClass(in);
        this.inputSplit = (InputSplit)ReflectionUtils.newInstance(this.inputSplitClass, (Configuration)this.conf);
        SerializationFactory factory = new SerializationFactory(this.conf);
        Deserializer deserializer = factory.getDeserializer(this.inputSplitClass);
        deserializer.open((InputStream)((DataInputStream)in));
        this.inputSplit = (InputSplit)deserializer.deserialize((Object)this.inputSplit);
    }

    private Class<?> readClass(DataInput in) throws IOException {
        String className = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        try {
            return this.conf.getClassByName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("readObject can't find class", e);
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.inputSplitClass.getName());
        Text.writeString((DataOutput)out, (String)this.inputFormatClass.getName());
        Text.writeString((DataOutput)out, (String)this.mapperClass.getName());
        SerializationFactory factory = new SerializationFactory(this.conf);
        Serializer serializer = factory.getSerializer(this.inputSplitClass);
        serializer.open((OutputStream)((DataOutputStream)out));
        serializer.serialize((Object)this.inputSplit);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.inputSplit.toString();
    }
}

