/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.mapreduce.IntegrationTestBulkLoad;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestFileBasedSFTBulkLoad
extends IntegrationTestBulkLoad {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestFileBasedSFTBulkLoad.class);
    private static String NUM_MAPS_KEY = "hbase.IntegrationTestBulkLoad.numMaps";
    private static String NUM_IMPORT_ROUNDS_KEY = "hbase.IntegrationTestBulkLoad.numImportRounds";
    private static String NUM_REPLICA_COUNT_KEY = "hbase.IntegrationTestBulkLoad.replicaCount";
    private static int NUM_REPLICA_COUNT_DEFAULT = 1;

    @Test
    public void testFileBasedSFTBulkLoad() throws Exception {
        super.testBulkLoad();
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.getConfiguration().set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        this.util.initializeCluster(1);
        int replicaCount = this.getConf().getInt(NUM_REPLICA_COUNT_KEY, NUM_REPLICA_COUNT_DEFAULT);
        if (LOG.isDebugEnabled() && replicaCount != NUM_REPLICA_COUNT_DEFAULT) {
            LOG.debug("Region Replicas enabled: " + replicaCount);
        }
        if (this.util.isDistributedCluster()) {
            this.util.getConfiguration().setIfUnset(NUM_MAPS_KEY, Integer.toString(this.util.getAdmin().getRegionServers().size() * 10));
            this.util.getConfiguration().setIfUnset(NUM_IMPORT_ROUNDS_KEY, "5");
        } else {
            this.util.startMiniMapReduceCluster();
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestFileBasedSFTBulkLoad(), (String[])args);
        System.exit(status);
    }
}

