/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.protobuf.generated.RefreshHFilesProtos;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshHFilesEndpoint
extends RefreshHFilesProtos.RefreshHFilesService
implements RegionCoprocessor {
    protected static final Logger LOG = LoggerFactory.getLogger(RefreshHFilesEndpoint.class);
    private RegionCoprocessorEnvironment env;

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void refreshHFiles(RpcController controller, RefreshHFilesProtos.RefreshHFilesRequest request, RpcCallback<RefreshHFilesProtos.RefreshHFilesResponse> done) {
        try {
            for (Store store : this.env.getRegion().getStores()) {
                LOG.debug("Refreshing HFiles for region: " + store.getRegionInfo().getRegionNameAsString() + " and store: " + store.getColumnFamilyName() + "class:" + store.getClass());
                store.refreshStoreFiles();
            }
        }
        catch (IOException ioe) {
            LOG.error("Exception while trying to refresh store files: ", (Throwable)ioe);
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)ioe);
        }
        done.run((Object)RefreshHFilesProtos.RefreshHFilesResponse.getDefaultInstance());
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

