/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LruCachedBlockQueue
implements HeapSize {
    private MinMaxPriorityQueue<LruCachedBlock> queue;
    private long heapSize;
    private long maxSize;

    public LruCachedBlockQueue(long maxSize, long blockSize) {
        Preconditions.checkArgument(blockSize > 0L, "negative blockSize %s", blockSize);
        Preconditions.checkArgument(maxSize > 0L, "negative maxSize %s", maxSize);
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.expectedSize(initialSize).create();
        this.heapSize = 0L;
        this.maxSize = maxSize;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="head can not be null as heapSize is greater than maxSize, which means we have something in the queue")
    public void add(LruCachedBlock cb) {
        if (this.heapSize < this.maxSize) {
            this.queue.add(cb);
            this.heapSize += cb.heapSize();
        } else {
            LruCachedBlock head = this.queue.peek();
            if (cb.compareTo(head) > 0) {
                this.heapSize += cb.heapSize();
                this.heapSize -= head.heapSize();
                if (this.heapSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.heapSize += head.heapSize();
                }
                this.queue.add(cb);
            }
        }
    }

    public LruCachedBlock poll() {
        return this.queue.poll();
    }

    public LruCachedBlock pollLast() {
        return this.queue.pollLast();
    }

    @Override
    public long heapSize() {
        return this.heapSize;
    }
}

