/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.DigestSaslAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DigestSaslServerAuthenticationProvider
extends DigestSaslAuthenticationProvider
implements SaslServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DigestSaslServerAuthenticationProvider.class);
    private AtomicReference<UserGroupInformation> attemptingUser = new AtomicReference<Object>(null);

    @Override
    public AttemptingUserProvidingSaslServer createServer(SecretManager<TokenIdentifier> secretManager, Map<String, String> saslProps) throws IOException {
        if (secretManager == null) {
            throw new AccessDeniedException("Server is not configured to do DIGEST authentication.");
        }
        SaslServer server = Sasl.createSaslServer(this.getSaslAuthMethod().getSaslMechanism(), null, "default", saslProps, new SaslDigestCallbackHandler(secretManager, this.attemptingUser));
        return new AttemptingUserProvidingSaslServer(server, () -> this.attemptingUser.get());
    }

    @Override
    public boolean supportsProtocolAuthentication() {
        return false;
    }

    @Override
    public UserGroupInformation getAuthorizedUgi(String authzId, SecretManager<TokenIdentifier> secretManager) throws IOException {
        TokenIdentifier tokenId = HBaseSaslRpcServer.getIdentifier(authzId, secretManager);
        UserGroupInformation authorizedUgi = tokenId.getUser();
        if (authorizedUgi == null) {
            throw new AccessDeniedException("Can't retrieve username from tokenIdentifier.");
        }
        authorizedUgi.addTokenIdentifier(tokenId);
        authorizedUgi.setAuthenticationMethod(this.getSaslAuthMethod().getAuthMethod());
        return authorizedUgi;
    }

    private static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private final SecretManager<TokenIdentifier> secretManager;
        private final AtomicReference<UserGroupInformation> attemptingUser;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, AtomicReference<UserGroupInformation> attemptingUser) {
            this.secretManager = secretManager;
            this.attemptingUser = attemptingUser;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken {
            return SaslUtil.encodePassword(this.secretManager.retrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = HBaseSaslRpcServer.getIdentifier(nc.getDefaultName(), this.secretManager);
                this.attemptingUser.set(tokenIdentifier.getUser());
                char[] password = this.getPassword(tokenIdentifier);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("SASL server DIGEST-MD5 callback: setting password for client: {}", (Object)tokenIdentifier.getUser());
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String userRequestedToExecuteAs;
                String authenticatedUserId = ac.getAuthenticationID();
                if (authenticatedUserId.equals(userRequestedToExecuteAs = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                    if (LOG.isTraceEnabled()) {
                        String username = HBaseSaslRpcServer.getIdentifier(userRequestedToExecuteAs, this.secretManager).getUser().getUserName();
                        LOG.trace("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username);
                    }
                    ac.setAuthorizedID(userRequestedToExecuteAs);
                } else {
                    ac.setAuthorized(false);
                }
            }
        }
    }
}

