/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.SimpleSaslServerAuthenticationProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SaslServerAuthenticationProviders {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientAuthenticationProviders.class);
    public static final String EXTRA_PROVIDERS_KEY = "hbase.server.sasl.provider.extras";
    private static final AtomicReference<SaslServerAuthenticationProviders> holder = new AtomicReference();
    private final HashMap<Byte, SaslServerAuthenticationProvider> providers;

    private SaslServerAuthenticationProviders(Configuration conf, HashMap<Byte, SaslServerAuthenticationProvider> providers) {
        this.providers = providers;
    }

    public int getNumRegisteredProviders() {
        return this.providers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SaslServerAuthenticationProviders getInstance(Configuration conf) {
        SaslServerAuthenticationProviders providers = holder.get();
        if (null == providers) {
            AtomicReference<SaslServerAuthenticationProviders> atomicReference = holder;
            synchronized (atomicReference) {
                providers = holder.get();
                if (null != providers) {
                    return providers;
                }
                providers = SaslServerAuthenticationProviders.createProviders(conf);
                holder.set(providers);
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        AtomicReference<SaslServerAuthenticationProviders> atomicReference = holder;
        synchronized (atomicReference) {
            holder.set(null);
        }
    }

    static void addProviderIfNotExists(SaslServerAuthenticationProvider provider, HashMap<Byte, SaslServerAuthenticationProvider> providers) {
        byte newProviderAuthCode = provider.getSaslAuthMethod().getCode();
        SaslServerAuthenticationProvider alreadyRegisteredProvider = providers.get(newProviderAuthCode);
        if (alreadyRegisteredProvider != null) {
            throw new RuntimeException("Trying to load SaslServerAuthenticationProvider " + provider.getClass() + ", but " + alreadyRegisteredProvider.getClass() + " is already registered with the same auth code");
        }
        providers.put(newProviderAuthCode, provider);
    }

    static void addExtraProviders(Configuration conf, HashMap<Byte, SaslServerAuthenticationProvider> providers) {
        for (String implName : conf.getStringCollection(EXTRA_PROVIDERS_KEY)) {
            Class<?> clz;
            try {
                clz = Class.forName(implName);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to find SaslServerAuthenticationProvider class {}", (Object)implName, (Object)e);
                continue;
            }
            if (!SaslServerAuthenticationProvider.class.isAssignableFrom(clz)) {
                LOG.warn("Server authentication class {} is not an instance of SaslServerAuthenticationProvider", clz);
                continue;
            }
            try {
                SaslServerAuthenticationProvider provider = (SaslServerAuthenticationProvider)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                SaslServerAuthenticationProviders.addProviderIfNotExists(provider, providers);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Failed to instantiate {}", clz, (Object)e);
            }
        }
    }

    static SaslServerAuthenticationProviders createProviders(Configuration conf) {
        ServiceLoader<SaslServerAuthenticationProvider> loader = ServiceLoader.load(SaslServerAuthenticationProvider.class);
        HashMap<Byte, SaslServerAuthenticationProvider> providers = new HashMap<Byte, SaslServerAuthenticationProvider>();
        for (SaslServerAuthenticationProvider provider2 : loader) {
            SaslServerAuthenticationProviders.addProviderIfNotExists(provider2, providers);
        }
        SaslServerAuthenticationProviders.addExtraProviders(conf, providers);
        if (LOG.isTraceEnabled()) {
            String loadedProviders = providers.values().stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(", "));
            if (loadedProviders.isEmpty()) {
                loadedProviders = "None!";
            }
            LOG.trace("Found SaslServerAuthenticationProviders {}", (Object)loadedProviders);
        }
        providers.forEach((b, provider) -> {
            try {
                provider.init(new Configuration(conf));
            }
            catch (IOException e) {
                LOG.error("Failed to initialize {}", provider.getClass(), (Object)e);
                throw new RuntimeException("Failed to initialize " + provider.getClass().getName(), e);
            }
        });
        return new SaslServerAuthenticationProviders(conf, providers);
    }

    public SaslServerAuthenticationProvider selectProvider(byte authByte) {
        return this.providers.get(authByte);
    }

    public SaslServerAuthenticationProvider getSimpleProvider() {
        Optional<SaslServerAuthenticationProvider> opt = this.providers.values().stream().filter(p -> p instanceof SimpleSaslServerAuthenticationProvider).findFirst();
        if (!opt.isPresent()) {
            throw new RuntimeException("SIMPLE authentication provider not available when it should be");
        }
        return opt.get();
    }
}

