/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class RecoverLeaseFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverLeaseFSUtils.class);

    private RecoverLeaseFSUtils() {
    }

    public static void recoverFileLease(FileSystem fs, Path p, Configuration conf) throws IOException {
        RecoverLeaseFSUtils.recoverFileLease(fs, p, conf, null);
    }

    public static void recoverFileLease(FileSystem fs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        if (fs instanceof FilterFileSystem) {
            fs = ((FilterFileSystem)fs).getRawFileSystem();
        }
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        RecoverLeaseFSUtils.recoverDFSFileLease((DistributedFileSystem)fs, p, conf, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean recoverDFSFileLease(DistributedFileSystem dfs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        LOG.info("Recover lease on dfs file " + p);
        long startWaiting = EnvironmentEdgeManager.currentTime();
        long recoveryTimeout = (long)conf.getInt("hbase.lease.recovery.timeout", 900000) + startWaiting;
        long firstPause = conf.getInt("hbase.lease.recovery.first.pause", 4000);
        long subsequentPauseBase = conf.getLong("hbase.lease.recovery.dfs.timeout", 64000L);
        Method isFileClosedMeth = null;
        boolean findIsFileClosedMeth = true;
        boolean recovered = false;
        int nbAttempt = 0;
        while (!recovered && !(recovered = RecoverLeaseFSUtils.recoverLease(dfs, nbAttempt, p, startWaiting))) {
            block12: {
                RecoverLeaseFSUtils.checkIfCancelled(reporter);
                if (RecoverLeaseFSUtils.checkIfTimedout(conf, recoveryTimeout, nbAttempt, p, startWaiting)) break;
                try {
                    if (nbAttempt == 0) {
                        Thread.sleep(firstPause);
                        break block12;
                    }
                    long localStartWaiting = EnvironmentEdgeManager.currentTime();
                    while (EnvironmentEdgeManager.currentTime() - localStartWaiting < subsequentPauseBase * (long)nbAttempt) {
                        Thread.sleep(conf.getInt("hbase.lease.recovery.pause", 1000));
                        if (findIsFileClosedMeth) {
                            try {
                                isFileClosedMeth = dfs.getClass().getMethod("isFileClosed", Path.class);
                            }
                            catch (NoSuchMethodException nsme) {
                                LOG.debug("isFileClosed not available");
                            }
                            finally {
                                findIsFileClosedMeth = false;
                            }
                        }
                        if (isFileClosedMeth != null && RecoverLeaseFSUtils.isFileClosed(dfs, isFileClosedMeth, p)) {
                            recovered = true;
                            break;
                        }
                        RecoverLeaseFSUtils.checkIfCancelled(reporter);
                    }
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            ++nbAttempt;
        }
        return recovered;
    }

    private static boolean checkIfTimedout(Configuration conf, long recoveryTimeout, int nbAttempt, Path p, long startWaiting) {
        if (recoveryTimeout < EnvironmentEdgeManager.currentTime()) {
            LOG.warn("Cannot recoverLease after trying for " + conf.getInt("hbase.lease.recovery.timeout", 900000) + "ms (hbase.lease.recovery.timeout); continuing, but may be DATALOSS!!!; " + RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
            return true;
        }
        return false;
    }

    private static boolean recoverLease(DistributedFileSystem dfs, int nbAttempt, Path p, long startWaiting) throws FileNotFoundException {
        boolean recovered = false;
        try {
            recovered = dfs.recoverLease(p);
            LOG.info((recovered ? "Recovered lease, " : "Failed to recover lease, ") + RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting));
        }
        catch (IOException e) {
            if (e instanceof LeaseExpiredException && e.getMessage().contains("File does not exist")) {
                throw new FileNotFoundException("The given WAL wasn't found at " + p);
            }
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            LOG.warn(RecoverLeaseFSUtils.getLogMessageDetail(nbAttempt, p, startWaiting), (Throwable)e);
        }
        return recovered;
    }

    private static String getLogMessageDetail(int nbAttempt, Path p, long startWaiting) {
        return "attempt=" + nbAttempt + " on file=" + p + " after " + (EnvironmentEdgeManager.currentTime() - startWaiting) + "ms";
    }

    private static boolean isFileClosed(DistributedFileSystem dfs, Method m3, Path p) {
        try {
            return (Boolean)m3.invoke((Object)dfs, p);
        }
        catch (SecurityException e) {
            LOG.warn("No access", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Failed invocation for " + p.toString(), (Throwable)e);
        }
        return false;
    }

    private static void checkIfCancelled(CancelableProgressable reporter) throws InterruptedIOException {
        if (reporter == null) {
            return;
        }
        if (!reporter.progress()) {
            throw new InterruptedIOException("Operation cancelled");
        }
    }
}

