/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class EntryBuffers {
    private static final Logger LOG = LoggerFactory.getLogger(EntryBuffers.class);
    private final WALSplitter.PipelineController controller;
    final Map<byte[], RegionEntryBuffer> buffers = new TreeMap<byte[], RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
    private final Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
    protected long totalBuffered = 0L;
    protected final long maxHeapUsage;

    public EntryBuffers(WALSplitter.PipelineController controller, long maxHeapUsage) {
        this.controller = controller;
        this.maxHeapUsage = maxHeapUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendEntry(WAL.Entry entry) throws InterruptedException, IOException {
        long incrHeap;
        WALKeyImpl key = entry.getKey();
        Object object = this;
        synchronized (object) {
            RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
            if (buffer == null) {
                buffer = new RegionEntryBuffer(key.getTableName(), key.getEncodedRegionName());
                this.buffers.put(key.getEncodedRegionName(), buffer);
            }
            incrHeap = buffer.appendEntry(entry);
        }
        object = this.controller.dataAvailable;
        synchronized (object) {
            this.totalBuffered += incrHeap;
            while (this.totalBuffered > this.maxHeapUsage && this.controller.thrown.get() == null) {
                LOG.debug("Used {} bytes of buffered edits, waiting for IO threads", (Object)this.totalBuffered);
                this.controller.dataAvailable.wait(2000L);
            }
            this.controller.dataAvailable.notifyAll();
        }
        this.controller.checkForErrors();
    }

    synchronized RegionEntryBuffer getChunkToWrite() {
        long biggestSize = 0L;
        byte[] biggestBufferKey = null;
        for (Map.Entry<byte[], RegionEntryBuffer> entry : this.buffers.entrySet()) {
            long size = entry.getValue().heapSize();
            if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
            biggestSize = size;
            biggestBufferKey = entry.getKey();
        }
        if (biggestBufferKey == null) {
            return null;
        }
        RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
        this.currentlyWriting.add(biggestBufferKey);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneWriting(RegionEntryBuffer buffer) {
        EntryBuffers entryBuffers = this;
        synchronized (entryBuffers) {
            boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
            assert (removed);
        }
        long size = buffer.heapSize();
        Object object = this.controller.dataAvailable;
        synchronized (object) {
            this.totalBuffered -= size;
            this.controller.dataAvailable.notifyAll();
        }
    }

    synchronized boolean isRegionCurrentlyWriting(byte[] region) {
        return this.currentlyWriting.contains(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDrained() {
        Object object = this.controller.dataAvailable;
        synchronized (object) {
            while (this.totalBuffered > 0L) {
                try {
                    this.controller.dataAvailable.wait(2000L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted while waiting for EntryBuffers is drained");
                    Thread.interrupted();
                    break;
                }
            }
        }
    }

    public static class RegionEntryBuffer
    implements HeapSize {
        private long heapInBuffer = 0L;
        final List<WAL.Entry> entries;
        final TableName tableName;
        final byte[] encodedRegionName;

        RegionEntryBuffer(TableName tableName, byte[] region) {
            this.tableName = tableName;
            this.encodedRegionName = region;
            this.entries = new ArrayList<WAL.Entry>();
        }

        long appendEntry(WAL.Entry entry) {
            this.internify(entry);
            this.entries.add(entry);
            long incrHeap = entry.getEdit().heapSize() + (long)ClassSize.align(2 * ClassSize.REFERENCE);
            this.heapInBuffer += incrHeap;
            return incrHeap;
        }

        private void internify(WAL.Entry entry) {
            WALKeyImpl k = entry.getKey();
            k.internTableName(this.tableName);
            k.internEncodedRegionName(this.encodedRegionName);
        }

        @Override
        public long heapSize() {
            return this.heapInBuffer;
        }

        public byte[] getEncodedRegionName() {
            return this.encodedRegionName;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public List<WAL.Entry> getEntries() {
            return this.entries;
        }
    }
}

