/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.SampledCacheManagerMBean;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.writer.writebehind.WriteBehindManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCacheManager
extends BaseEmitterBean
implements SampledCacheManagerMBean {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final CacheManager cacheManager;
    private String mbeanRegisteredName;
    private volatile boolean mbeanRegisteredNameSet;
    private final EventListener cacheManagerEventListener;

    public SampledCacheManager(CacheManager cacheManager) throws NotCompliantMBeanException {
        super(SampledCacheManagerMBean.class);
        this.cacheManager = cacheManager;
        this.cacheManagerEventListener = new EventListener();
        cacheManager.setCacheManagerEventListener(this.cacheManagerEventListener);
    }

    @Override
    protected void doDispose() {
        this.cacheManager.getCacheManagerEventListenerRegistry().unregisterListener(this.cacheManagerEventListener);
    }

    void setMBeanRegisteredName(String name) {
        if (this.mbeanRegisteredNameSet) {
            throw new IllegalStateException("Name used for registering this mbean is already set");
        }
        this.mbeanRegisteredNameSet = true;
        this.mbeanRegisteredName = name;
    }

    @Override
    public void clearAll() {
        this.cacheManager.clearAll();
        this.sendNotification("CachesCleared");
    }

    @Override
    public String[] getCacheNames() throws IllegalStateException {
        return this.cacheManager.getCacheNames();
    }

    @Override
    public String getStatus() {
        return this.cacheManager.getStatus().toString();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map<String, long[]> getCacheMetrics() {
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result.put(cacheName, new long[]{stats.getCacheHitMostRecentSample(), stats.getCacheMissNotFoundMostRecentSample() + stats.getCacheMissExpiredMostRecentSample(), stats.getCacheElementPutMostRecentSample()});
        }
        return result;
    }

    @Override
    public long getCacheHitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheMissRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissNotFoundMostRecentSample() + stats.getCacheMissExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCachePutRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementPutMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheUpdateRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementUpdatedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheEvictionRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementEvictedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheExpirationRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheSearchRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getSearchesPerSecond();
        }
        return result;
    }

    @Override
    public long getCacheAverageSearchTime() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getAverageSearchTime();
        }
        return result;
    }

    @Override
    public boolean getHasWriteBehindWriter() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !(cache.getWriterManager() instanceof WriteBehindManager) || cache.getRegisteredCacheWriter() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getWriterQueueLength() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            LiveCacheStatistics stats = cache.getLiveCacheStatistics();
            result += Math.max(stats.getWriterQueueLength(), 0L);
        }
        return result;
    }

    @Override
    public int getWriterMaxQueueSize() {
        int result = 0;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            CacheWriterConfiguration writerConfig = cache.getCacheConfiguration().getCacheWriterConfiguration();
            result += writerConfig.getWriteBehindMaxQueueSize() * writerConfig.getWriteBehindConcurrency();
        }
        return result;
    }

    @Override
    public String getName() {
        return this.cacheManager.getName();
    }

    @Override
    public String getMBeanRegisteredName() {
        return this.mbeanRegisteredName;
    }

    @Override
    public void clearStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.clearStatistics();
        }
        this.sendNotification("StatisticsReset");
    }

    @Override
    public void enableStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setSampledStatisticsEnabled(true);
        }
        this.sendNotification("StatisticsEnabled", Boolean.TRUE);
    }

    @Override
    public void disableStatistics() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setStatisticsEnabled(false);
        }
        this.sendNotification("StatisticsEnabled", Boolean.FALSE);
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            this.enableStatistics();
        } else {
            this.disableStatistics();
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || cache.isSampledStatisticsEnabled()) continue;
            return false;
        }
        return true;
    }

    private boolean determineStatisticsEnabled() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || cache.isStatisticsEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManager.getActiveConfigurationText();
    }

    @Override
    public String generateActiveConfigDeclaration(String cacheName) {
        return this.cacheManager.getActiveConfigurationText(cacheName);
    }

    @Override
    public boolean getTransactional() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !cache.getCacheConfiguration().getTransactionalMode().isTransactional()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getSearchable() {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || cache.getCacheConfiguration().getSearchable() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getTransactionCommittedCount() {
        return this.cacheManager.getTransactionController().getTransactionCommittedCount();
    }

    @Override
    public long getTransactionCommitRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheXaCommitsMostRecentSample();
        }
        return result;
    }

    @Override
    public long getTransactionRolledBackCount() {
        return this.cacheManager.getTransactionController().getTransactionRolledBackCount();
    }

    @Override
    public long getTransactionRollbackRate() {
        long result = 0L;
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheXaRollbacksMostRecentSample();
        }
        return result;
    }

    @Override
    public long getTransactionTimedOutCount() {
        return this.cacheManager.getTransactionController().getTransactionTimedOutCount();
    }

    @Override
    public boolean isEnabled() throws CacheException {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (String cacheName : this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            cache.setDisabled(!enabled);
        }
        this.sendNotification("CachesEnabled", enabled);
    }

    private boolean determineEnabled() {
        for (String cacheName : this.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    static {
        String[] notifTypes = new String[]{"CachesEnabled", "CachesCleared", "StatisticsEnabled", "StatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCacheManager Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCacheManager Event")};
    }

    private class EventListener
    implements CacheManagerEventListener {
        private Status status = Status.STATUS_UNINITIALISED;

        private EventListener() {
        }

        public void dispose() throws CacheException {
            this.status = Status.STATUS_SHUTDOWN;
        }

        public Status getStatus() {
            return this.status;
        }

        public void init() throws CacheException {
            this.status = Status.STATUS_ALIVE;
        }

        public void notifyCacheAdded(String cacheName) {
        }

        public void notifyCacheRemoved(String cacheName) {
        }
    }
}

