/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotEntrySerializer
implements ElementSerializer<Entry> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MavibotEntrySerializer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static SchemaManager schemaManager;

    public int compare(Entry entry1, Entry entry2) {
        return entry1.getDn().getName().compareTo(entry1.getDn().getName());
    }

    public Comparator<Entry> getComparator() {
        return null;
    }

    public byte[] serialize(Entry entry) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int totalBytes = 0;
            baos.write(0);
            baos.write(0);
            baos.write(0);
            baos.write(0);
            ObjectOutputStream out = new ObjectOutputStream(baos);
            Dn dn = entry.getDn();
            if (dn.isEmpty()) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
                Rdn rdn = dn.getRdn();
                rdn.writeExternal((ObjectOutput)out);
            }
            out.writeInt(entry.getAttributes().size());
            for (Attribute attribute : entry.getAttributes()) {
                AttributeType attributeType = attribute.getAttributeType();
                String oid = attributeType.getOid();
                out.writeUTF(oid);
                attribute.writeExternal((ObjectOutput)out);
            }
            out.flush();
            if (IS_DEBUG) {
                LOG.debug(">------------------------------------------------");
                LOG.debug("Serialize " + entry);
            }
            byte[] bytes = baos.toByteArray();
            totalBytes = bytes.length - 4;
            bytes[0] = (byte)(totalBytes >>> 24);
            bytes[1] = (byte)(totalBytes >>> 16);
            bytes[2] = (byte)(totalBytes >>> 8);
            bytes[3] = (byte)totalBytes;
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Entry deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.array(), buffer.position(), len));
        try {
            DefaultEntry entry = new DefaultEntry(schemaManager);
            byte hasDn = in.readByte();
            if (hasDn == 1) {
                Rdn rdn = new Rdn(schemaManager);
                rdn.readExternal((ObjectInput)in);
                try {
                    entry.setDn(new Dn(schemaManager, new Rdn[]{rdn}));
                }
                catch (LdapInvalidDnException lide) {
                    IOException ioe = new IOException(lide.getMessage());
                    ioe.initCause(lide);
                    throw ioe;
                }
            } else {
                entry.setDn(Dn.EMPTY_DN);
            }
            int nbAttributes = in.readInt();
            for (int i = 0; i < nbAttributes; ++i) {
                String oid = in.readUTF();
                try {
                    AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(oid);
                    DefaultAttribute attribute = new DefaultAttribute(attributeType);
                    attribute.readExternal((ObjectInput)in);
                    entry.add(new Attribute[]{attribute});
                    continue;
                }
                catch (LdapException ne) {
                    throw new ClassNotFoundException(ne.getMessage(), ne);
                }
            }
            buffer.position(buffer.position() + len);
            return entry;
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error(I18n.err((I18n)I18n.ERR_134, (Object[])new Object[]{cnfe.getLocalizedMessage()}));
            throw new IOException(cnfe.getLocalizedMessage());
        }
    }

    public Entry deserialize(BufferHandler bufferHandler) throws IOException {
        return this.deserialize(ByteBuffer.wrap(bufferHandler.getBuffer()));
    }

    public static void setSchemaManager(SchemaManager schemaManager) {
        MavibotEntrySerializer.schemaManager = schemaManager;
    }
}

