/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_collector_monitor_bind", indexes={@Index(name="idx_collector_monitor_collector", columnList="collector"), @Index(name="idx_collector_monitor_monitor_id", columnList="monitor_id")})
@Schema(description="slave collector monitor bind entity")
@EntityListeners(value={AuditingEntityListener.class})
public class CollectorMonitorBind {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="primary id", example="23")
    private Long id;
    @Schema(title="collector name", example="87432674384")
    private String collector;
    @Schema(title="monitor ID", example="87432674336")
    @Column(name="monitor_id")
    private Long monitorId;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static CollectorMonitorBindBuilder builder() {
        return new CollectorMonitorBindBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getCollector() {
        return this.collector;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCollector(String collector) {
        this.collector = collector;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectorMonitorBind)) {
            return false;
        }
        CollectorMonitorBind other = (CollectorMonitorBind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        String this$collector = this.getCollector();
        String other$collector = other.getCollector();
        if (this$collector == null ? other$collector != null : !this$collector.equals(other$collector)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectorMonitorBind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        String $collector = this.getCollector();
        result = result * 59 + ($collector == null ? 43 : $collector.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "CollectorMonitorBind(id=" + this.getId() + ", collector=" + this.getCollector() + ", monitorId=" + this.getMonitorId() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public CollectorMonitorBind(Long id, String collector, Long monitorId, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.collector = collector;
        this.monitorId = monitorId;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public CollectorMonitorBind() {
    }

    public static class CollectorMonitorBindBuilder {
        private Long id;
        private String collector;
        private Long monitorId;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        CollectorMonitorBindBuilder() {
        }

        public CollectorMonitorBindBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public CollectorMonitorBindBuilder collector(String collector) {
            this.collector = collector;
            return this;
        }

        public CollectorMonitorBindBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public CollectorMonitorBindBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public CollectorMonitorBindBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public CollectorMonitorBindBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public CollectorMonitorBindBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public CollectorMonitorBind build() {
            return new CollectorMonitorBind(this.id, this.collector, this.monitorId, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "CollectorMonitorBind.CollectorMonitorBindBuilder(id=" + this.id + ", collector=" + this.collector + ", monitorId=" + this.monitorId + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

