/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Consumer;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;

public class MessageHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "message-handler";
    private final Consumer<InNetworkObject> messageListener;
    private final InternalClusterNode remoteNode;
    private final short connectionIndex;
    private final PerSessionSerializationService serializationService;

    public MessageHandler(Consumer<InNetworkObject> messageListener, InternalClusterNode remoteNode, short connectionIndex, PerSessionSerializationService serializationService) {
        this.messageListener = messageListener;
        this.remoteNode = remoteNode;
        this.connectionIndex = connectionIndex;
        this.serializationService = serializationService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NetworkMessage message = (NetworkMessage)msg;
        if (MessageHandler.notPayloadMessage(message)) {
            return;
        }
        this.messageListener.accept(new InNetworkObject(message, this.remoteNode, this.connectionIndex, this.serializationService.compositeDescriptorRegistry()));
    }

    private static boolean notPayloadMessage(NetworkMessage message) {
        return message instanceof AcknowledgementMessage || message instanceof ProbeMessage;
    }
}

