/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.failure;

import java.util.UUID;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class FailureContext {
    private final FailureType type;
    @Nullable
    private final Throwable err;
    private final String message;
    private final UUID id = UUID.randomUUID();

    public FailureContext(Throwable err) {
        this(FailureType.CRITICAL_ERROR, err);
    }

    public FailureContext(FailureType type, Throwable err) {
        this(type, err, "Unknown error");
    }

    public FailureContext(Throwable err, String message) {
        this(FailureType.CRITICAL_ERROR, err, message);
    }

    public FailureContext(FailureType type, @Nullable Throwable err, String message) {
        this.type = type;
        this.err = err;
        this.message = message;
    }

    public FailureType type() {
        return this.type;
    }

    @Nullable
    public Throwable error() {
        return this.err;
    }

    public String message() {
        return this.message;
    }

    public UUID id() {
        return this.id;
    }

    public String toString() {
        return S.toString(FailureContext.class, this);
    }
}

