/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.io.Serializable;
import org.apache.ignite.cache.store.jdbc.JdbcTypeField;
import org.apache.ignite.cache.store.jdbc.JdbcTypeHasher;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcType
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private String dbSchema;
    private String dbTbl;
    private String keyType;
    @GridToStringInclude
    private JdbcTypeField[] keyFields;
    private String valType;
    @GridToStringInclude
    private JdbcTypeField[] valFlds;
    private JdbcTypeHasher hasher;

    public JdbcType() {
    }

    public JdbcType(JdbcType type) {
        this.cacheName = type.getCacheName();
        this.dbSchema = type.getDatabaseSchema();
        this.dbTbl = type.getDatabaseTable();
        this.keyType = type.getKeyType();
        this.keyFields = type.getKeyFields();
        this.valType = type.getValueType();
        this.valFlds = type.getValueFields();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public JdbcType setCacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public String getDatabaseSchema() {
        return this.dbSchema;
    }

    public JdbcType setDatabaseSchema(String dbSchema) {
        this.dbSchema = dbSchema;
        return this;
    }

    public String getDatabaseTable() {
        return this.dbTbl;
    }

    public JdbcType setDatabaseTable(String dbTbl) {
        this.dbTbl = dbTbl;
        return this;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public JdbcType setKeyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public JdbcType setKeyType(Class<?> cls) {
        this.setKeyType(cls.getName());
        return this;
    }

    public String getValueType() {
        return this.valType;
    }

    public JdbcType setValueType(String valType) {
        this.valType = valType;
        return this;
    }

    public JdbcType setValueType(Class<?> cls) {
        this.setValueType(cls.getName());
        return this;
    }

    public JdbcTypeField[] getKeyFields() {
        return this.keyFields;
    }

    public JdbcType setKeyFields(JdbcTypeField ... keyFlds) {
        this.keyFields = keyFlds;
        return this;
    }

    public JdbcTypeField[] getValueFields() {
        return this.valFlds;
    }

    public JdbcType setValueFields(JdbcTypeField ... valFlds) {
        this.valFlds = valFlds;
        return this;
    }

    public String toString() {
        return S.toString(JdbcType.class, this);
    }
}

