/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.ScoredCacheEntry;
import org.apache.ignite.internal.processors.cache.query.reducer.CacheQueryReducer;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheQueryFutureAdapter<K, V, R>
extends GridFutureAdapter<Collection<R>>
implements CacheQueryFuture<R>,
GridTimeoutObject {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    protected static IgniteLogger log;
    private static final Object NULL;
    protected GridCacheContext<K, V> cctx;
    protected final GridCacheQueryBean qry;
    private int capacity;
    private boolean limitDisabled;
    private int cnt;
    private final IgniteUuid timeoutId = IgniteUuid.randomUuid();
    private long endTime;
    protected boolean loc;
    protected CacheQueryReducer<R> reducer;

    protected GridCacheQueryFutureAdapter() {
        this.qry = null;
    }

    protected GridCacheQueryFutureAdapter(GridCacheContext<K, V> cctx, GridCacheQueryBean qry, boolean loc) {
        this.cctx = cctx;
        this.qry = qry;
        this.loc = loc;
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheQueryFutureAdapter.class);
        }
        long startTime = U.currentTimeMillis();
        long timeout = qry.query().timeout();
        this.capacity = this.query().query().limit();
        boolean bl = this.limitDisabled = this.capacity <= 0;
        if (timeout > 0L) {
            this.endTime = startTime + timeout;
            if (this.endTime < 0L) {
                this.endTime = Long.MAX_VALUE;
            }
            cctx.time().addTimeoutObject(this);
        }
    }

    public GridCacheQueryBean query() {
        return this.qry;
    }

    @Override
    public IgniteLogger logger() {
        return log;
    }

    public boolean fields() {
        return false;
    }

    @Override
    public R next() {
        try {
            if (!this.limitDisabled && this.cnt == this.capacity) {
                return null;
            }
            this.checkError();
            R next = null;
            if (this.reducer.hasNextX()) {
                next = (R)this.unmaskNull(this.unwrapIfNeeded(this.reducer.nextX()));
                if (!this.limitDisabled) {
                    ++this.cnt;
                    if (this.cnt == this.capacity) {
                        this.cancel();
                    }
                }
            }
            return next;
        }
        catch (IgniteCheckedException e) {
            throw CU.convertToCacheException(e);
        }
    }

    public GridCacheContext<K, V> cacheContext() {
        return this.cctx;
    }

    public abstract void awaitFirstItemAvailable() throws IgniteCheckedException;

    private void checkError() throws IgniteCheckedException {
        if (this.error() != null) {
            this.clear();
            throw U.cast(this.error());
        }
    }

    protected void onNodeLeft(UUID evtNodeId) {
    }

    public void onPage(@Nullable UUID nodeId, @Nullable IndexQueryResultMeta metadata, @Nullable Collection<?> data, @Nullable Throwable err, boolean lastPage) {
        block15: {
            if (this.isCancelled()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(S.toString("Received query result page", "nodeId", (Object)nodeId, false, "data", data, true, "err", (Object)err, false, "finished", (Object)lastPage, false));
            }
            try {
                if (err != null) {
                    if (!(err instanceof IgniteCheckedException)) {
                        err = new IgniteCheckedException(nodeId != null ? S.toString("Failed to execute query on node", "query", (Object)this.qry, true, "nodeId", (Object)nodeId, false) : S.toString("Failed to execute query locally", "query", (Object)this.qry, true), err);
                    }
                    this.onError(err);
                } else {
                    if (data == null) {
                        data = Collections.emptyList();
                    }
                    if (this.qry.query().type() == GridCacheQueryType.TEXT) {
                        ArrayList unwrapped = new ArrayList();
                        for (Object o : data) {
                            ScoredCacheEntry e = (ScoredCacheEntry)o;
                            Object uKey = CacheObjectUtils.unwrapBinary(this.cctx.cacheObjectContext(), e.getKey(), this.qry.query().keepBinary(), true, null);
                            Object uVal = CacheObjectUtils.unwrapBinary(this.cctx.cacheObjectContext(), e.getValue(), this.qry.query().keepBinary(), true, null);
                            if (uKey != e.getKey() || uVal != e.getValue()) {
                                unwrapped.add(new ScoredCacheEntry<Object, Object>(uKey, uVal, e.score()));
                                continue;
                            }
                            unwrapped.add(o);
                        }
                        data = unwrapped;
                    } else if (this.qry.query().type() != GridCacheQueryType.INDEX) {
                        data = this.cctx.unwrapBinariesIfNeeded(data, this.qry.query().keepBinary());
                    }
                    if (this.query().query().type() == GridCacheQueryType.INDEX) {
                        this.onMeta(metadata);
                    }
                    this.onPage(nodeId, data, lastPage);
                    if (this.isDone()) {
                        this.clear();
                    }
                }
            }
            catch (Throwable e) {
                this.onError(e);
                if (!(e instanceof Error)) break block15;
                throw (Error)e;
            }
        }
    }

    protected abstract void onError(Throwable var1);

    protected abstract void onPage(UUID var1, Collection<R> var2, boolean var3);

    protected void onMeta(IndexQueryResultMeta meta) {
    }

    @Override
    public boolean onDone(Collection<R> res, Throwable err) {
        boolean done = super.onDone(res, err);
        this.cctx.time().removeTimeoutObject(this);
        return done;
    }

    private Collection<Object> maskNulls(Collection<Object> col) {
        assert (col != null);
        return F.viewReadOnly(col, new C1<Object, Object>(){

            @Override
            public Object apply(Object e) {
                return e != null ? e : NULL;
            }
        }, new IgnitePredicate[0]);
    }

    private Collection<Object> unmaskNulls(Collection<Object> col) {
        assert (col != null);
        return F.viewReadOnly(col, new C1<Object, Object>(){

            @Override
            public Object apply(Object e) {
                return e != NULL ? e : null;
            }
        }, new IgnitePredicate[0]);
    }

    private R unmaskNull(R obj) {
        return (R)(obj != NULL ? obj : null);
    }

    private R unwrapIfNeeded(R obj) {
        if (this.qry.query().type() == GridCacheQueryType.INDEX) {
            return (R)this.cctx.unwrapBinaryIfNeeded(obj, this.qry.query().keepBinary(), false, null);
        }
        return obj;
    }

    void clear() {
    }

    @Override
    public boolean cancel() throws IgniteCheckedException {
        if (this.onCancelled()) {
            this.cancelQuery(new IgniteCheckedException("Query was cancelled."));
            return true;
        }
        return false;
    }

    protected abstract void cancelQuery(Throwable var1) throws IgniteCheckedException;

    @Override
    public IgniteUuid timeoutId() {
        return this.timeoutId;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void onTimeout() {
        this.onError(new IgniteFutureTimeoutCheckedException("Query timed out."));
    }

    @Override
    public void close() throws Exception {
        this.cancel();
    }

    @Override
    public String toString() {
        return S.toString(GridCacheQueryFutureAdapter.class, this);
    }

    static {
        NULL = new Object();
    }
}

