/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.baserpc.RPCContext;
import org.apache.bifromq.baserpc.client.IBiDiStream;
import org.apache.bifromq.baserpc.client.util.FastBehaviorSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BiDiStream<InT, OutT>
implements IBiDiStream<InT, OutT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BiDiStream.class);
    private final String serverId;
    private final ClientCallStreamObserver<InT> callStreamObserver;
    private final Subject<OutT> outSubject = PublishSubject.create();
    private final Subject<Long> onReadySubject = FastBehaviorSubject.create();
    private final AtomicBoolean isCancelled = new AtomicBoolean();
    private final AtomicBoolean isClosed = new AtomicBoolean();

    BiDiStream(String tenantId, final String serverId, Channel channel, MethodDescriptor<InT, OutT> methodDescriptor, Map<String, String> metadata, CallOptions callOptions) {
        this.serverId = serverId;
        Context ctx = Context.ROOT.fork().withValue(RPCContext.TENANT_ID_CTX_KEY, (Object)tenantId).withValue(RPCContext.DESIRED_SERVER_ID_CTX_KEY, (Object)serverId).withValue(RPCContext.CUSTOM_METADATA_CTX_KEY, metadata);
        this.callStreamObserver = (ClientCallStreamObserver)ctx.call(() -> (ClientCallStreamObserver)ClientCalls.asyncBidiStreamingCall((ClientCall)channel.newCall(methodDescriptor, callOptions), (StreamObserver)new ClientResponseObserver<Object, OutT>(){

            public void beforeStart(ClientCallStreamObserver<Object> requestStream) {
                requestStream.setOnReadyHandler(() -> BiDiStream.this.onReadySubject.onNext((Object)System.nanoTime()));
            }

            public void onNext(OutT outT) {
                BiDiStream.this.outSubject.onNext(outT);
            }

            public void onError(Throwable t) {
                log.trace("BiDiStream error: serverId={}", (Object)serverId, (Object)t);
                BiDiStream.this.outSubject.onError(t);
                BiDiStream.this.onReadySubject.onComplete();
            }

            public void onCompleted() {
                BiDiStream.this.outSubject.onComplete();
                BiDiStream.this.onReadySubject.onComplete();
            }
        }));
    }

    @Override
    public Observable<OutT> onNext() {
        return this.outSubject;
    }

    @Override
    public Observable<Long> onReady() {
        return this.onReadySubject;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public boolean isReady() {
        return this.callStreamObserver.isReady();
    }

    @Override
    public void cancel(String message) {
        if (this.isCancelled.compareAndSet(false, true)) {
            this.callStreamObserver.cancel(message, null);
        }
    }

    @Override
    public void send(InT in) {
        try {
            this.callStreamObserver.onNext(in);
        }
        catch (Throwable e) {
            log.error("Failed to send message", e);
        }
    }

    @Override
    public void close() {
        if (this.isCancelled.get()) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            this.callStreamObserver.onCompleted();
        }
    }
}

