/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class ProgramDriver {
    Map<String, ProgramDescription> programs = new TreeMap<String, ProgramDescription>();

    private static void printUsage(Map<String, ProgramDescription> programs) {
        System.out.println("Valid program names are:");
        for (Map.Entry<String, ProgramDescription> item : programs.entrySet()) {
            System.out.println("  " + item.getKey() + ": " + item.getValue().getDescription());
        }
    }

    public void addClass(String name, Class<?> mainClass, String description) throws Throwable {
        this.programs.put(name, new ProgramDescription(mainClass, description));
    }

    public int run(String[] args2) throws Throwable {
        if (args2.length == 0) {
            System.out.println("An example program must be given as the first argument.");
            ProgramDriver.printUsage(this.programs);
            return -1;
        }
        ProgramDescription pgm = this.programs.get(args2[0]);
        if (pgm == null) {
            System.out.println("Unknown program '" + args2[0] + "' chosen.");
            ProgramDriver.printUsage(this.programs);
            return -1;
        }
        String[] new_args = new String[args2.length - 1];
        for (int i = 1; i < args2.length; ++i) {
            new_args[i - 1] = args2[i];
        }
        pgm.invoke(new_args);
        return 0;
    }

    public void driver(String[] argv) throws Throwable {
        if (this.run(argv) == -1) {
            System.exit(-1);
        }
    }

    private static class ProgramDescription {
        static final Class<?>[] paramTypes = new Class[]{String[].class};
        private Method main;
        private String description;

        public ProgramDescription(Class<?> mainClass, String description) throws SecurityException, NoSuchMethodException {
            this.main = mainClass.getMethod("main", paramTypes);
            this.description = description;
        }

        public void invoke(String[] args2) throws Throwable {
            try {
                this.main.invoke(null, new Object[]{args2});
            }
            catch (InvocationTargetException except) {
                throw except.getCause();
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

