/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.utils.StringUtils;

public class RetryingMetaStoreClientFactory {
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS = ImmutableMap.builder().put(new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName)).put(new Class[]{HiveConf.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).put(new Class[]{HiveConf.class, Class[].class, Object[].class, ConcurrentHashMap.class, String.class}, RetryingMetaStoreClientFactory::constructorDetectedHiveMetastoreProxySupplier).put(new Class[]{Configuration.class, HiveMetaHookLoader.class, ConcurrentHashMap.class, String.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, tbl -> null, new ConcurrentHashMap(), clientClassName, true)).put(new Class[]{Configuration.class, Class[].class, Object[].class, ConcurrentHashMap.class, String.class}, RetryingMetaStoreClientFactory::constructorDetectedHiveMetastoreProxySupplier).build();
    private static final Map<Class<?>[], HiveMetastoreProxySupplier> PROXY_SUPPLIERS_SHADED = ImmutableMap.builder().put(new Class[]{HiveConf.class}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf)).put(new Class[]{HiveConf.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).put(new Class[]{Configuration.class, Boolean.TYPE}, (getProxyMethod, hiveConf, clientClassName) -> (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, true)).build();

    public IMetaStoreClient createClient(HiveConf hiveConf, String clientClassName) {
        LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier> suppliers = new LinkedHashMap<Class<?>[], HiveMetastoreProxySupplier>(PROXY_SUPPLIERS);
        if (HiveMetaStoreClient.class.getName().equals(clientClassName)) {
            suppliers.putAll(PROXY_SUPPLIERS_SHADED);
        }
        RuntimeException failToCreate = new RuntimeException("Failed to create the desired metastore client (class name: " + clientClassName + ")");
        for (Map.Entry entry : suppliers.entrySet()) {
            Class[] classes = (Class[])entry.getKey();
            try {
                Method getProxy = RetryingMetaStoreClient.class.getMethod("getProxy", classes);
                HiveMetastoreProxySupplier supplier = (HiveMetastoreProxySupplier)entry.getValue();
                IMetaStoreClient client = supplier.get(getProxy, (Configuration)hiveConf, clientClassName);
                return StringUtils.isNullOrWhitespaceOnly(hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname)) ? client : HiveMetaStoreClient.newSynchronizedClient((IMetaStoreClient)client);
            }
            catch (Exception e) {
                failToCreate.addSuppressed(e);
            }
        }
        throw failToCreate;
    }

    private static IMetaStoreClient constructorDetectedHiveMetastoreProxySupplier(Method getProxyMethod, Configuration hiveConf, String clientClassName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Class<?> baseClass = Class.forName(clientClassName, false, JavaUtils.getClassLoader());
            List<Class> possibleFirstParamTypes = Arrays.asList(getProxyMethod.getParameterTypes()[0], hiveConf.getClass());
            for (Class possibleFirstParamType : possibleFirstParamTypes) {
                Class[] fullParams = new Class[]{possibleFirstParamType, HiveMetaHookLoader.class, Boolean.TYPE};
                Object[] fullParamValues = new Object[]{hiveConf, tbl -> null, Boolean.TRUE};
                for (int i = fullParams.length; i >= 1; --i) {
                    try {
                        baseClass.getConstructor(Arrays.copyOfRange(fullParams, 0, i));
                        return (IMetaStoreClient)getProxyMethod.invoke(null, hiveConf, Arrays.copyOfRange(fullParams, 0, i), Arrays.copyOfRange(fullParamValues, 0, i), new ConcurrentHashMap(), clientClassName);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Failed to create the desired metastore client with proper constructors (class name: " + clientClassName + ")");
    }

    public static interface HiveMetastoreProxySupplier {
        public IMetaStoreClient get(Method var1, Configuration var2, String var3) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;
    }
}

