/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.iceberg.metadata.IcebergDataField;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergSchema {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_SCHEMA_ID = "schema-id";
    private static final String FIELD_FIELDS = "fields";
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="schema-id")
    private final int schemaId;
    @JsonProperty(value="fields")
    private final List<IcebergDataField> fields;

    public static IcebergSchema create(TableSchema tableSchema) {
        return new IcebergSchema((int)tableSchema.id(), tableSchema.fields().stream().map(IcebergDataField::new).collect(Collectors.toList()));
    }

    public IcebergSchema(int schemaId, List<IcebergDataField> fields) {
        this("struct", schemaId, fields);
    }

    @JsonCreator
    public IcebergSchema(@JsonProperty(value="type") String type, @JsonProperty(value="schema-id") int schemaId, @JsonProperty(value="fields") List<IcebergDataField> fields) {
        this.type = type;
        this.schemaId = schemaId;
        this.fields = fields;
    }

    @JsonGetter(value="type")
    public String type() {
        return this.type;
    }

    @JsonGetter(value="schema-id")
    public int schemaId() {
        return this.schemaId;
    }

    @JsonGetter(value="fields")
    public List<IcebergDataField> fields() {
        return this.fields;
    }

    @JsonIgnore
    public int highestFieldId() {
        return this.fields.stream().mapToInt(IcebergDataField::id).max().orElse(0);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.schemaId, this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergSchema)) {
            return false;
        }
        IcebergSchema that = (IcebergSchema)o;
        return Objects.equals(this.type, that.type) && this.schemaId == that.schemaId && Objects.equals(this.fields, that.fields);
    }
}

