/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.ValueBulkLoader;
import org.apache.paimon.lookup.ValueState;
import org.apache.paimon.lookup.memory.InMemoryState;

public class InMemoryValueState<K, V>
extends InMemoryState<K, V>
implements ValueState<K, V> {
    private final Map<ByteArray, byte[]> values = new HashMap<ByteArray, byte[]>();

    public InMemoryValueState(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
    }

    @Override
    @Nullable
    public V get(K key) throws IOException {
        byte[] bytes = this.values.get(ByteArray.wrapBytes(this.serializeKey(key)));
        if (bytes == null) {
            return null;
        }
        return this.deserializeValue(bytes);
    }

    @Override
    public void put(K key, V value) throws IOException {
        this.values.put(ByteArray.wrapBytes(this.serializeKey(key)), this.serializeValue(value));
    }

    @Override
    public void delete(K key) throws IOException {
        this.values.remove(ByteArray.wrapBytes(this.serializeKey(key)));
    }

    @Override
    public ValueBulkLoader createBulkLoader() {
        return new ValueBulkLoader(){

            @Override
            public void write(byte[] key, byte[] value) {
                InMemoryValueState.this.values.put(ByteArray.wrapBytes(key), value);
            }

            @Override
            public void finish() {
            }
        };
    }
}

