/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.NoopCompactManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.RowCompactedSerializer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.IndexMaintainer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RecordLevelExpire;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.LookupStrategy;
import org.apache.paimon.mergetree.Levels;
import org.apache.paimon.mergetree.LookupFile;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.MergeTreeWriter;
import org.apache.paimon.mergetree.compact.CompactStrategy;
import org.apache.paimon.mergetree.compact.ForceUpLevel0Compaction;
import org.apache.paimon.mergetree.compact.FullChangelogMergeTreeCompactRewriter;
import org.apache.paimon.mergetree.compact.LookupMergeTreeCompactRewriter;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManager;
import org.apache.paimon.mergetree.compact.MergeTreeCompactRewriter;
import org.apache.paimon.mergetree.compact.UniversalCompaction;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.MemoryFileStoreWrite;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.UserDefinedSeqComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueFileStoreWrite
extends MemoryFileStoreWrite<KeyValue> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueFileStoreWrite.class);
    private final KeyValueFileReaderFactory.Builder readerFactoryBuilder;
    private final KeyValueFileWriterFactory.Builder writerFactoryBuilder;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final Supplier<FieldsComparator> udsComparatorSupplier;
    private final Supplier<RecordEqualiser> logDedupEqualSupplier;
    private final MergeFunctionFactory<KeyValue> mfFactory;
    private final CoreOptions options;
    private final FileIO fileIO;
    private final RowType keyType;
    private final RowType valueType;
    private final RowType partitionType;
    private final String commitUser;
    @Nullable
    private final RecordLevelExpire recordLevelExpire;
    @Nullable
    private Cache<String, LookupFile> lookupFileCache;

    public KeyValueFileStoreWrite(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, String commitUser, RowType partitionType, RowType keyType, RowType valueType, Supplier<Comparator<InternalRow>> keyComparatorSupplier, Supplier<FieldsComparator> udsComparatorSupplier, Supplier<RecordEqualiser> logDedupEqualSupplier, MergeFunctionFactory<KeyValue> mfFactory, FileStorePathFactory pathFactory, BiFunction<CoreOptions, String, FileStorePathFactory> formatPathFactory, SnapshotManager snapshotManager, FileStoreScan scan, @Nullable IndexMaintainer.Factory<KeyValue> indexFactory, @Nullable DeletionVectorsMaintainer.Factory deletionVectorsMaintainerFactory, CoreOptions options, KeyValueFieldsExtractor extractor, String tableName) {
        super(snapshotManager, scan, options, partitionType, indexFactory, deletionVectorsMaintainerFactory, tableName);
        this.fileIO = fileIO;
        this.partitionType = partitionType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.commitUser = commitUser;
        this.udsComparatorSupplier = udsComparatorSupplier;
        this.readerFactoryBuilder = KeyValueFileReaderFactory.builder(fileIO, schemaManager, schema, keyType, valueType, FileFormatDiscover.of(options), pathFactory, extractor, options);
        this.recordLevelExpire = RecordLevelExpire.create(options, schema, schemaManager);
        this.writerFactoryBuilder = KeyValueFileWriterFactory.builder(fileIO, schema.id(), keyType, valueType, FileFormat.fileFormat(options), FileStorePathFactory.createFormatPathFactories(options, formatPathFactory), options.targetFileSize(true));
        this.keyComparatorSupplier = keyComparatorSupplier;
        this.logDedupEqualSupplier = logDedupEqualSupplier;
        this.mfFactory = mfFactory;
        this.options = options;
    }

    protected MergeTreeWriter createWriter(BinaryRow partition, int bucket, List<DataFileMeta> restoreFiles, long restoredMaxSeqNumber, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor, @Nullable DeletionVectorsMaintainer dvMaintainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating merge tree writer for partition {} bucket {} from restored files {}", new Object[]{partition, bucket, restoreFiles});
        }
        KeyValueFileWriterFactory writerFactory = this.writerFactoryBuilder.build(partition, bucket, this.options);
        Comparator<InternalRow> keyComparator = this.keyComparatorSupplier.get();
        Levels levels = new Levels(keyComparator, restoreFiles, this.options.numLevels());
        CompactStrategy compactStrategy = this.createCompactStrategy(this.options);
        CompactManager compactManager = this.createCompactManager(partition, bucket, compactStrategy, compactExecutor, levels, dvMaintainer);
        return new MergeTreeWriter(this.bufferSpillable(), this.options.writeBufferSpillDiskSize(), this.options.localSortMaxNumFileHandles(), this.options.spillCompressOptions(), this.ioManager, compactManager, restoredMaxSeqNumber, keyComparator, this.mfFactory.create(), writerFactory, this.options.commitForceCompact(), this.options.changelogProducer(), restoreIncrement, UserDefinedSeqComparator.create(this.valueType, this.options));
    }

    @VisibleForTesting
    public boolean bufferSpillable() {
        return this.options.writeBufferSpillable(this.fileIO.isObjectStore(), this.isStreamingMode, true);
    }

    private CompactStrategy createCompactStrategy(CoreOptions options) {
        if (options.needLookup()) {
            if (CoreOptions.LookupCompactMode.RADICAL.equals((Object)options.lookupCompact())) {
                return new ForceUpLevel0Compaction(new UniversalCompaction(options.maxSizeAmplificationPercent(), options.sortedRunSizeRatio(), options.numSortedRunCompactionTrigger(), options.optimizedCompactionInterval()));
            }
            if (CoreOptions.LookupCompactMode.GENTLE.equals((Object)options.lookupCompact())) {
                return new UniversalCompaction(options.maxSizeAmplificationPercent(), options.sortedRunSizeRatio(), options.numSortedRunCompactionTrigger(), options.optimizedCompactionInterval(), options.lookupCompactMaxInterval());
            }
        }
        UniversalCompaction universal = new UniversalCompaction(options.maxSizeAmplificationPercent(), options.sortedRunSizeRatio(), options.numSortedRunCompactionTrigger(), options.optimizedCompactionInterval());
        if (options.compactionForceUpLevel0()) {
            return new ForceUpLevel0Compaction(universal);
        }
        return universal;
    }

    private CompactManager createCompactManager(BinaryRow partition, int bucket, CompactStrategy compactStrategy, ExecutorService compactExecutor, Levels levels, @Nullable DeletionVectorsMaintainer dvMaintainer) {
        if (this.options.writeOnly()) {
            return new NoopCompactManager();
        }
        Comparator<InternalRow> keyComparator = this.keyComparatorSupplier.get();
        FieldsComparator userDefinedSeqComparator = this.udsComparatorSupplier.get();
        MergeTreeCompactRewriter rewriter = this.createRewriter(partition, bucket, keyComparator, userDefinedSeqComparator, levels, dvMaintainer);
        return new MergeTreeCompactManager(compactExecutor, levels, compactStrategy, keyComparator, this.options.compactionFileSize(true), this.options.numSortedRunStopTrigger(), rewriter, this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(partition, bucket), dvMaintainer, this.options.prepareCommitWaitCompaction(), this.options.needLookup(), this.recordLevelExpire, this.options.forceRewriteAllFiles());
    }

    private MergeTreeCompactRewriter createRewriter(BinaryRow partition, int bucket, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, Levels levels, @Nullable DeletionVectorsMaintainer dvMaintainer) {
        DeletionVector.Factory dvFactory = DeletionVector.factory(dvMaintainer);
        FileReaderFactory<KeyValue> readerFactory = this.readerFactoryBuilder.build(partition, bucket, dvFactory);
        if (this.recordLevelExpire != null) {
            readerFactory = this.recordLevelExpire.wrap(readerFactory);
        }
        KeyValueFileWriterFactory writerFactory = this.writerFactoryBuilder.build(partition, bucket, this.options);
        MergeSorter mergeSorter = new MergeSorter(this.options, this.keyType, this.valueType, this.ioManager);
        int maxLevel = this.options.numLevels() - 1;
        CoreOptions.MergeEngine mergeEngine = this.options.mergeEngine();
        CoreOptions.ChangelogProducer changelogProducer = this.options.changelogProducer();
        LookupStrategy lookupStrategy = this.options.lookupStrategy();
        if (changelogProducer.equals(CoreOptions.ChangelogProducer.FULL_COMPACTION)) {
            return new FullChangelogMergeTreeCompactRewriter(maxLevel, mergeEngine, readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, this.mfFactory, mergeSorter, this.logDedupEqualSupplier.get());
        }
        if (lookupStrategy.needLookup) {
            LookupMergeTreeCompactRewriter.MergeFunctionWrapperFactory<Boolean> wrapperFactory;
            LookupLevels.ValueProcessor<LookupLevels.PositionedKeyValue> processor;
            FileReaderFactory<KeyValue> lookupReaderFactory = readerFactory;
            if (lookupStrategy.isFirstRow) {
                if (this.options.deletionVectorsEnabled()) {
                    throw new UnsupportedOperationException("First row merge engine does not need deletion vectors because there is no deletion of old data in this merge engine.");
                }
                lookupReaderFactory = this.readerFactoryBuilder.copyWithoutProjection().withReadValueType(RowType.of()).build(partition, bucket, dvFactory);
                processor = new LookupLevels.ContainsValueProcessor();
                wrapperFactory = new LookupMergeTreeCompactRewriter.FirstRowMergeFunctionWrapperFactory();
            } else {
                processor = lookupStrategy.deletionVector ? new LookupLevels.PositionedKeyValueProcessor(this.valueType, lookupStrategy.produceChangelog || mergeEngine != CoreOptions.MergeEngine.DEDUPLICATE || !this.options.sequenceField().isEmpty()) : new LookupLevels.KeyValueProcessor(this.valueType);
                wrapperFactory = new LookupMergeTreeCompactRewriter.LookupMergeFunctionWrapperFactory(this.logDedupEqualSupplier.get(), lookupStrategy, UserDefinedSeqComparator.create(this.valueType, this.options));
            }
            return new LookupMergeTreeCompactRewriter<Boolean>(maxLevel, mergeEngine, this.createLookupLevels(partition, bucket, levels, processor, lookupReaderFactory), readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, this.mfFactory, mergeSorter, wrapperFactory, lookupStrategy.produceChangelog, dvMaintainer, this.options);
        }
        return new MergeTreeCompactRewriter(readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, this.mfFactory, mergeSorter);
    }

    private <T> LookupLevels<T> createLookupLevels(BinaryRow partition, int bucket, Levels levels, LookupLevels.ValueProcessor<T> valueProcessor, FileReaderFactory<KeyValue> readerFactory) {
        if (this.ioManager == null) {
            throw new RuntimeException("Can not use lookup, there is no temp disk directory to use.");
        }
        LookupStoreFactory lookupStoreFactory = LookupStoreFactory.create(this.options, this.cacheManager, new RowCompactedSerializer(this.keyType).createSliceComparator());
        Options options = this.options.toConfiguration();
        if (this.lookupFileCache == null) {
            this.lookupFileCache = LookupFile.createCache(options.get(CoreOptions.LOOKUP_CACHE_FILE_RETENTION), options.get(CoreOptions.LOOKUP_CACHE_MAX_DISK_SIZE));
        }
        return new LookupLevels<T>(levels, this.keyComparatorSupplier.get(), this.keyType, valueProcessor, readerFactory::createRecordReader, file -> this.ioManager.createChannel(LookupFile.localFilePrefix(this.partitionType, partition, bucket, file)).getPathFile(), lookupStoreFactory, LookupStoreFactory.bfGenerator(options), this.lookupFileCache);
    }

    @Override
    protected Function<AbstractFileStoreWrite.WriterContainer<KeyValue>, Boolean> createWriterCleanChecker() {
        return KeyValueFileStoreWrite.createConflictAwareWriterCleanChecker(this.commitUser, this.snapshotManager);
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.lookupFileCache != null) {
            this.lookupFileCache.invalidateAll();
        }
    }
}

